/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverListener;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverSetupException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public final class ClientDriver {
    private final Server jettyServer;
    private final int port;
    private final List<ClientDriverListener> listeners = new ArrayList<ClientDriverListener>();
    private final ClientDriverJettyHandler handler;

    public ClientDriver(ClientDriverJettyHandler handler) {
        this(handler, ClientDriver.getFreePort());
    }

    public ClientDriver(ClientDriverJettyHandler handler, int port) {
        this.port = port;
        this.handler = handler;
        this.jettyServer = new Server(port);
        this.startJetty();
    }

    private void startJetty() {
        try {
            this.jettyServer.setHandler((Handler)this.handler);
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new ClientDriverSetupException("Error starting jetty on port " + this.port, e);
        }
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.port;
    }

    public static int getFreePort() {
        try {
            ServerSocket server = new ServerSocket(0);
            int port = server.getLocalPort();
            server.close();
            return port;
        }
        catch (IOException ioe) {
            throw new ClientDriverSetupException("IOException finding free port", ioe);
        }
    }

    public void verify() {
        this.handler.checkForUnexpectedRequests();
        this.handler.checkForUnmatchedExpectations();
    }

    public void shutdownQuietly() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw new ClientDriverFailedExpectationException("Error shutting down jetty", e);
        }
        finally {
            this.completed();
        }
    }

    public void shutdown() {
        this.shutdownQuietly();
        this.verify();
    }

    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        return this.handler.addExpectation(request, response);
    }

    void addListener(ClientDriverListener listener) {
        this.listeners.add(listener);
    }

    private void completed() {
        for (ClientDriverListener listener : this.listeners) {
            listener.hasCompleted();
        }
    }
}

