/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RealRequest;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class HttpRealRequest
implements RealRequest {
    private final ClientDriverRequest.Method method;
    private final String path;
    private final Multimap<String, String> params;
    private final Map<String, Object> headers;
    private final String bodyContent;
    private final String bodyContentType;

    public HttpRealRequest(HttpServletRequest request) {
        this.path = request.getPathInfo();
        this.method = Enum.valueOf(ClientDriverRequest.Method.class, request.getMethod());
        this.params = HashMultimap.create();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry paramEntry : parameterMap.entrySet()) {
            String[] values;
            for (String value : values = (String[])paramEntry.getValue()) {
                this.params.put(paramEntry.getKey(), (Object)value);
            }
        }
        this.headers = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                this.headers.put(headerName, request.getHeader(headerName));
            }
        }
        try {
            this.bodyContent = IOUtils.toString((Reader)request.getReader());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read body of request", e);
        }
        this.bodyContentType = request.getContentType();
    }

    @Override
    public final ClientDriverRequest.Method getMethod() {
        return this.method;
    }

    @Override
    public final String getPath() {
        return this.path;
    }

    @Override
    public final Map<String, Collection<String>> getParams() {
        if (this.params == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.params.asMap());
    }

    @Override
    public final Map<String, Object> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public final String getBodyContent() {
        return this.bodyContent;
    }

    @Override
    public final String getBodyContentType() {
        return this.bodyContentType;
    }
}

