/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RealRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRequestMatcher
implements RequestMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestMatcher.class);

    @Override
    public boolean isMatch(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        boolean sameMethod = this.isSameMethod(realRequest, expectedRequest);
        if (!sameMethod) {
            return false;
        }
        boolean sameBasePath = this.isSameBasePath(realRequest, expectedRequest);
        if (!sameBasePath) {
            return false;
        }
        boolean sameQueryString = this.hasSameQueryString(realRequest, expectedRequest);
        if (!sameQueryString) {
            return false;
        }
        boolean sameHeaders = this.hasSameHeaders(realRequest, expectedRequest);
        if (!sameHeaders) {
            return false;
        }
        boolean sameBody = this.hasSameBody(realRequest, expectedRequest);
        return sameBody;
    }

    private boolean isSameMethod(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (realRequest.getMethod() != expectedRequest.getMethod()) {
            LOGGER.info("REJECTED on method: expected " + (Object)((Object)expectedRequest.getMethod()) + " != " + (Object)((Object)realRequest.getMethod()));
            return false;
        }
        return true;
    }

    private boolean isSameBasePath(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (!this.isStringOrPatternMatch(realRequest.getPath(), expectedRequest.getPath())) {
            LOGGER.info("REJECTED on path: expected " + expectedRequest.getPath() + " != " + realRequest.getPath());
            return false;
        }
        return true;
    }

    private boolean hasSameQueryString(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (expectedRequest.getAnyParams()) {
            return true;
        }
        Map<String, Collection<String>> actualParams = realRequest.getParams();
        Map<String, Collection<Matcher<? extends String>>> expectedParams = expectedRequest.getParams();
        if (actualParams.size() != expectedParams.size()) {
            LOGGER.info("REJECTED on number of params: expected " + expectedParams.size() + " != " + actualParams.size());
            return false;
        }
        for (String expectedKey : expectedParams.keySet()) {
            Collection<String> actualParamValues = actualParams.get(expectedKey);
            if (actualParamValues == null || actualParamValues.size() == 0) {
                LOGGER.info("REJECTED on missing param key: expected " + expectedKey + "=" + expectedParams.get(expectedKey));
                return false;
            }
            Collection<Matcher<? extends String>> expectedParamValues = expectedParams.get(expectedKey);
            if (expectedParamValues.size() != actualParamValues.size()) {
                LOGGER.info("REJECTED on number of values for param '" + expectedKey + "': expected " + expectedParamValues.size() + " != " + actualParamValues.size());
                return false;
            }
            boolean sameParamValues = this.containsMatch(expectedKey, actualParamValues, expectedParamValues);
            if (sameParamValues) continue;
            return false;
        }
        return true;
    }

    private boolean containsMatch(String expectedKey, Collection<String> actualParamValues, Collection<Matcher<? extends String>> expectedParamValues) {
        for (Matcher<? extends String> expectedParamValue : expectedParamValues) {
            boolean matched = false;
            for (String actualParamValue : actualParamValues) {
                if (!expectedParamValue.matches((Object)actualParamValue)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            LOGGER.info("REJECTED on unmatched params key: expected " + expectedKey + "=" + expectedParamValue);
            return false;
        }
        return true;
    }

    private boolean hasSameHeaders(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        Map<String, Object> expectedHeaders = expectedRequest.getHeaders();
        Map<String, Object> actualHeaders = realRequest.getHeaders();
        for (String expectedHeaderName : expectedHeaders.keySet()) {
            Object expectedHeaderValue = expectedHeaders.get(expectedHeaderName);
            boolean matched = false;
            block1: for (Map.Entry<String, Object> actualHeader : actualHeaders.entrySet()) {
                Object value = actualHeader.getValue();
                if (value instanceof Enumeration) {
                    Enumeration valueEnumeration = (Enumeration)value;
                    while (valueEnumeration.hasMoreElements()) {
                        String currentValue = (String)valueEnumeration.nextElement();
                        if (!this.isStringOrPatternMatch(currentValue, expectedHeaderValue)) continue;
                        matched = true;
                        continue block1;
                    }
                    continue;
                }
                if (!this.isStringOrPatternMatch((String)value, expectedHeaderValue)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            if (expectedHeaderValue instanceof String) {
                LOGGER.info("REJECTED on missing header: expected " + expectedHeaderName + "=" + (String)expectedHeaderValue);
            } else {
                LOGGER.info("REJECTED on missing header: expected " + expectedHeaderName + "=" + (Pattern)expectedHeaderValue);
            }
            return false;
        }
        return true;
    }

    private boolean hasSameBody(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (expectedRequest.getBodyContentType() != null) {
            String actualContentType = realRequest.getBodyContentType();
            if (actualContentType == null) {
                return false;
            }
            if (actualContentType.contains(";")) {
                actualContentType = actualContentType.substring(0, actualContentType.indexOf(59));
            }
            if (!this.isStringOrPatternMatch(actualContentType, expectedRequest.getBodyContentType())) {
                if (expectedRequest.getBodyContentType() instanceof String) {
                    LOGGER.info("REJECTED on content type: expected " + (String)expectedRequest.getBodyContentType() + ", actual " + actualContentType);
                } else {
                    LOGGER.info("REJECTED on content type: expected " + ((Pattern)expectedRequest.getBodyContentType()).pattern() + ", actual " + actualContentType);
                }
                return false;
            }
        }
        if (expectedRequest.getBodyContentMatcher() != null) {
            String actualContent = realRequest.getBodyContent();
            boolean hasMatchingBodyContent = expectedRequest.getBodyContentMatcher().matches((Object)actualContent);
            if (!hasMatchingBodyContent) {
                StringDescription description = new StringDescription();
                expectedRequest.getBodyContentMatcher().describeTo((Description)description);
                description.appendText(" ");
                expectedRequest.getBodyContentMatcher().describeMismatch((Object)actualContent, (Description)description);
                LOGGER.info("REJECTED on content: Expected {}", (Object)description.toString());
                return false;
            }
        }
        return true;
    }

    private boolean isStringOrPatternMatch(String actual, Object expected) {
        if (actual == null) {
            actual = "";
        }
        if (expected instanceof String) {
            return actual.equals(expected);
        }
        if (expected instanceof Pattern) {
            Pattern pattern = (Pattern)expected;
            return pattern.matcher(actual).matches();
        }
        throw new ClientDriverInternalException("DefaultRequestMatcher asked to match " + expected.getClass() + ", but only knows String and Pattern.", null);
    }
}

