/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RealRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRequestMatcher
implements RequestMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestMatcher.class);

    @Override
    public boolean isMatch(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (!this.isSameMethod(realRequest, expectedRequest)) {
            return false;
        }
        if (!this.isSameBasePath(realRequest, expectedRequest)) {
            return false;
        }
        if (!this.hasSameQueryString(realRequest, expectedRequest)) {
            return false;
        }
        if (this.hasExcludedHeaders(realRequest, expectedRequest)) {
            return false;
        }
        if (!this.hasSameHeaders(realRequest, expectedRequest)) {
            return false;
        }
        if (!this.hasSameBody(realRequest, expectedRequest)) {
            return false;
        }
        this.captureBodyIfRequired(realRequest, expectedRequest);
        return true;
    }

    private void captureBodyIfRequired(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (expectedRequest.getBodyCapture() != null) {
            expectedRequest.getBodyCapture().setBody(realRequest.getBodyContent());
        }
    }

    private boolean isSameMethod(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (realRequest.getMethod() != expectedRequest.getMethod()) {
            LOGGER.info("({} {}) REJECTED on method: expected {} != {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedRequest.getMethod(), realRequest.getMethod()});
            return false;
        }
        return true;
    }

    private boolean isSameBasePath(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (!expectedRequest.getPath().matches((Object)realRequest.getPath())) {
            LOGGER.info("({} {}) REJECTED on path: expected {} != {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedRequest.getPath(), realRequest.getPath()});
            return false;
        }
        return true;
    }

    private boolean hasSameQueryString(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (expectedRequest.getAnyParams()) {
            return true;
        }
        Map<String, Collection<String>> actualParams = realRequest.getParams();
        Map<String, Collection<Matcher<? extends String>>> expectedParams = expectedRequest.getParams();
        if (actualParams.size() != expectedParams.size()) {
            LOGGER.info("({} {}) REJECTED on number of params: expected {} != {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedParams.size(), actualParams.size()});
            return false;
        }
        for (String expectedKey : expectedParams.keySet()) {
            Collection<String> actualParamValues = actualParams.get(expectedKey);
            if (actualParamValues == null || actualParamValues.size() == 0) {
                LOGGER.info("({} {}) REJECTED on missing param key: expected {} = {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedKey, expectedParams.get(expectedKey)});
                return false;
            }
            Collection<Matcher<? extends String>> expectedParamValues = expectedParams.get(expectedKey);
            if (expectedParamValues.size() != actualParamValues.size()) {
                LOGGER.info("({} {}) REJECTED on number of values for param '{}': expected {} != {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedKey, expectedParamValues.size(), actualParamValues.size()});
                return false;
            }
            boolean sameParamValues = this.containsMatch(realRequest, expectedKey, actualParamValues, expectedParamValues);
            if (sameParamValues) continue;
            return false;
        }
        return true;
    }

    private boolean containsMatch(RealRequest realRequest, String expectedKey, Collection<String> actualParamValues, Collection<Matcher<? extends String>> expectedParamValues) {
        for (Matcher<? extends String> expectedParamValue : expectedParamValues) {
            boolean matched = false;
            for (String actualParamValue : actualParamValues) {
                if (!expectedParamValue.matches((Object)actualParamValue)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            LOGGER.info("({} {}) REJECTED on unmatched params key: expected {} = {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedKey, expectedParamValue});
            return false;
        }
        return true;
    }

    private boolean hasExcludedHeaders(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        Set<String> excludedHeaders = expectedRequest.getExcludedHeaders();
        Map<String, Object> actualHeaders = realRequest.getHeaders();
        for (String excludedHeader : excludedHeaders) {
            if (!actualHeaders.containsKey(excludedHeader)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameHeaders(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        Map<String, Matcher<? extends String>> expectedHeaders = expectedRequest.getHeaders();
        Map<String, Object> actualHeaders = realRequest.getHeaders();
        for (String expectedHeaderName : expectedHeaders.keySet()) {
            Matcher<? extends String> expectedHeaderValue = expectedHeaders.get(expectedHeaderName);
            boolean matched = false;
            block1: for (Map.Entry<String, Object> actualHeader : actualHeaders.entrySet()) {
                Object value = actualHeader.getValue();
                if (value instanceof Enumeration) {
                    Enumeration valueEnumeration = (Enumeration)value;
                    while (valueEnumeration.hasMoreElements()) {
                        String currentValue = (String)valueEnumeration.nextElement();
                        if (!expectedHeaderValue.matches((Object)currentValue)) continue;
                        matched = true;
                        continue block1;
                    }
                    continue;
                }
                if (!expectedHeaderValue.matches((Object)((String)value))) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            LOGGER.info("({} {}) REJECTED on missing header: expected {} = {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedHeaderName, expectedHeaderValue});
            return false;
        }
        return true;
    }

    private boolean hasSameBody(RealRequest realRequest, ClientDriverRequest expectedRequest) {
        if (expectedRequest.getBodyContentType() != null) {
            String actualContentType = realRequest.getBodyContentType();
            if (actualContentType == null) {
                return false;
            }
            if (actualContentType.contains(";")) {
                actualContentType = actualContentType.substring(0, actualContentType.indexOf(59));
            }
            if (!expectedRequest.getBodyContentType().matches((Object)actualContentType)) {
                LOGGER.info("({} {}) REJECTED on content type: expected {}, actual {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), expectedRequest.getBodyContentType(), actualContentType});
                return false;
            }
        }
        if (expectedRequest.getBodyContentMatcher() != null) {
            String actualContent = realRequest.getBodyContent();
            boolean hasMatchingBodyContent = expectedRequest.getBodyContentMatcher().matches((Object)actualContent);
            if (!hasMatchingBodyContent) {
                StringDescription description = new StringDescription();
                expectedRequest.getBodyContentMatcher().describeTo((Description)description);
                description.appendText(" ");
                expectedRequest.getBodyContentMatcher().describeMismatch((Object)actualContent, (Description)description);
                LOGGER.info("({} {}) REJECTED on content: Expected {}", new Object[]{realRequest.getMethod(), realRequest.getPath(), description.toString()});
                return false;
            }
        }
        return true;
    }
}

