/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.capture.BodyCapture;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;

public final class RestClientDriver {
    private RestClientDriver() {
    }

    public static ClientDriverRequest onRequestTo(Matcher<? extends String> path) {
        return new ClientDriverRequest(path);
    }

    public static ClientDriverRequest onRequestTo(String path) {
        return new ClientDriverRequest(path);
    }

    public static ClientDriverRequest onRequestTo(Pattern path) {
        return new ClientDriverRequest(path);
    }

    @Deprecated
    public static ClientDriverResponse giveResponse(String content) {
        return new ClientDriverResponse(content);
    }

    public static ClientDriverResponse giveResponse(String content, String contentType) {
        return new ClientDriverResponse(content, contentType);
    }

    public static ClientDriverResponse giveResponseAsBytes(InputStream content, String contentType) {
        return new ClientDriverResponse(content, contentType);
    }

    public static ClientDriverResponse giveEmptyResponse() {
        return new ClientDriverResponse();
    }

    public static void waitFor(BodyCapture<?> bodyCapture, long time, TimeUnit timeUnit) {
        long waitUntil = System.currentTimeMillis() + timeUnit.toMillis(time);
        while (waitUntil > System.currentTimeMillis() && bodyCapture.getContent() == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new ClientDriverFailedExpectationException("Interrupted waiting for capture", e);
            }
        }
    }
}

