/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver.jetty;

import com.github.restdriver.RestDriverProperties;
import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverRequestResponsePair;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.HttpRealRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultClientDriverJettyHandler
extends AbstractHandler
implements ClientDriverJettyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientDriverJettyHandler.class);
    private static final long DEFAULT_WAIT_INTERVAL = 500L;
    private final List<ClientDriverExpectation> expectations = new ArrayList<ClientDriverExpectation>();
    private final List<ClientDriverRequestResponsePair> matchedResponses = new ArrayList<ClientDriverRequestResponsePair>();
    private final RequestMatcher matcher;
    private final List<String> unexpectedRequests = new ArrayList<String>();

    public DefaultClientDriverJettyHandler(RequestMatcher matcher) {
        this.matcher = matcher;
    }

    public synchronized void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.info("Handling: {} {}", (Object)request.getMethod(), (Object)request.getPathInfo());
        ClientDriverRequestResponsePair matchingPair = this.getMatchingRequestPair(request);
        this.matchedResponses.add(matchingPair);
        ClientDriverResponse matchedResponse = matchingPair.getResponse();
        response.setContentType(matchedResponse.getContentType());
        response.setStatus(matchedResponse.getStatus());
        response.setHeader("Server", "rest-client-driver(" + RestDriverProperties.getVersion() + ")");
        for (Map.Entry<String, String> thisHeader : matchedResponse.getHeaders().entrySet()) {
            response.setHeader(thisHeader.getKey(), thisHeader.getValue());
        }
        if (matchedResponse.hasBody()) {
            ServletOutputStream output = response.getOutputStream();
            output.write(matchedResponse.getContentAsBytes());
        }
        this.delayIfNecessary(matchingPair.getResponse());
        baseRequest.setHandled(true);
    }

    private void delayIfNecessary(ClientDriverResponse response) {
        if (response.getDelayTime() > 0L) {
            try {
                response.getDelayTimeUnit().sleep(response.getDelayTime());
            }
            catch (InterruptedException ie) {
                throw new ClientDriverInternalException("Requested delay was interrupted", ie);
            }
        }
    }

    private ClientDriverRequestResponsePair getMatchingRequestPair(HttpServletRequest request) {
        int index;
        ClientDriverExpectation matchedExpectation = null;
        HttpRealRequest realRequest = new HttpRealRequest(request);
        for (index = 0; index < this.expectations.size(); ++index) {
            ClientDriverExpectation thisExpectation = this.expectations.get(index);
            ClientDriverRequestResponsePair thisPair = thisExpectation.getPair();
            if (!this.matcher.isMatch(realRequest, thisPair.getRequest())) continue;
            thisExpectation.match(realRequest);
            if (matchedExpectation != null) continue;
            matchedExpectation = thisExpectation;
            break;
        }
        if (matchedExpectation == null) {
            String unexpectedRequest = request.getMethod() + " " + request.getPathInfo();
            String reqQuery = request.getQueryString();
            if (reqQuery != null) {
                unexpectedRequest = unexpectedRequest + "?" + reqQuery;
            }
            this.unexpectedRequests.add(unexpectedRequest);
            throw new ClientDriverInternalException("Unexpected request(s): " + this.unexpectedRequests, null);
        }
        if (matchedExpectation.isSatisfied()) {
            this.expectations.remove(index);
        }
        return matchedExpectation.getPair();
    }

    @Override
    public void checkForUnexpectedRequests() {
        if (!this.unexpectedRequests.isEmpty()) {
            throw new ClientDriverFailedExpectationException("Unexpected request(s): " + this.unexpectedRequests, null);
        }
    }

    @Override
    public void checkForUnmatchedExpectations() {
        if (this.expectations.isEmpty()) {
            return;
        }
        long period = 0L;
        ClientDriverExpectation failedExpectation = null;
        block0: do {
            if (period > 0L) {
                this.waitFor(period);
                period = 0L;
            }
            for (ClientDriverExpectation expectation : this.expectations) {
                ClientDriverResponse response = expectation.getPair().getResponse();
                if (expectation.shouldMatchAnyTimes()) continue;
                if (response.canExpire() && response.hasNotExpired()) {
                    period = 500L;
                    continue block0;
                }
                failedExpectation = expectation;
            }
        } while (period > 0L);
        if (failedExpectation != null) {
            throw new ClientDriverFailedExpectationException(this.expectations.size() + " unmatched expectation(s), first is: " + failedExpectation.getPair().getRequest() + failedExpectation.getStatusString(), null);
        }
    }

    private void waitFor(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ie) {
            throw new ClientDriverInternalException("Waiting for requests was interrupted", ie);
        }
    }

    @Override
    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        ClientDriverRequestResponsePair pair = new ClientDriverRequestResponsePair(request, response);
        ClientDriverExpectation expectation = new ClientDriverExpectation(pair);
        this.expectations.add(expectation);
        return expectation;
    }
}

