/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverListener;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.exception.ClientDriverSetupException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDriver.class);
    private static final int MAX_TRIES = 10;
    private final Server jettyServer;
    private int port = -1;
    private final List<ClientDriverListener> listeners = new ArrayList<ClientDriverListener>();
    private final ClientDriverJettyHandler handler;

    public ClientDriver(ClientDriverJettyHandler handler) {
        this(handler, 0);
    }

    public ClientDriver(ClientDriverJettyHandler handler, int port) {
        this.handler = handler;
        this.jettyServer = this.createAndStartJetty(port);
    }

    private Server createAndStartJetty(int port) {
        int tries = this.triesForPort(port);
        for (int retries = 0; retries < tries; ++retries) {
            Server jetty = new Server(port);
            jetty.setHandler((Handler)this.handler);
            for (Connector connector : jetty.getConnectors()) {
                if (!(connector instanceof AbstractNetworkConnector)) continue;
                ((AbstractNetworkConnector)connector).setHost("0.0.0.0");
            }
            try {
                jetty.start();
                for (Connector connector : jetty.getConnectors()) {
                    if (!(connector instanceof NetworkConnector)) continue;
                    this.port = ((NetworkConnector)connector).getLocalPort();
                    break;
                }
                if (this.port == -1) {
                    throw new IllegalStateException("Local port was not set");
                }
                return jetty;
            }
            catch (BindException e) {
                if (retries >= tries - 1) continue;
                LOGGER.warn("Could not bind to port; trying again");
                continue;
            }
            catch (Exception e) {
                throw new ClientDriverSetupException("Error starting jetty on port " + port, e);
            }
        }
        throw new ClientDriverSetupException("Error starting jetty on port " + port + " after " + tries + " tries", null);
    }

    private int triesForPort(int port) {
        return port == 0 ? 10 : 1;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.port;
    }

    public static int getFreePort() {
        try {
            ServerSocket server = new ServerSocket(0);
            int port = server.getLocalPort();
            server.close();
            return port;
        }
        catch (IOException ioe) {
            throw new ClientDriverSetupException("IOException finding free port", ioe);
        }
    }

    public void verify() {
        LOGGER.info("Beginning verification");
        this.handler.checkForUnexpectedRequests();
        this.handler.checkForUnmatchedExpectations();
    }

    public void noFailFastOnUnexpectedRequest() {
        this.handler.noFailFastOnUnexpectedRequest();
    }

    public void reset() {
        this.handler.reset();
    }

    public void shutdownQuietly() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw new ClientDriverInternalException("Error shutting down jetty", e);
        }
        finally {
            this.completed();
        }
    }

    public void shutdown() {
        this.shutdownQuietly();
        this.verify();
    }

    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        return this.handler.addExpectation(request, response);
    }

    void addListener(ClientDriverListener listener) {
        this.listeners.add(listener);
    }

    private void completed() {
        for (ClientDriverListener listener : this.listeners) {
            listener.hasCompleted();
        }
    }
}

