/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver.jetty;

import com.github.restdriver.RestDriverProperties;
import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverRequestResponsePair;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.HttpRealRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultClientDriverJettyHandler
extends AbstractHandler
implements ClientDriverJettyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientDriverJettyHandler.class);
    private static final long DEFAULT_WAIT_INTERVAL = 500L;
    private final List<ClientDriverExpectation> expectations = new ArrayList<ClientDriverExpectation>();
    private final List<ClientDriverRequestResponsePair> matchedResponses = new ArrayList<ClientDriverRequestResponsePair>();
    private final RequestMatcher matcher;
    private final List<HttpRealRequest> unexpectedRequests = new ArrayList<HttpRealRequest>();
    private boolean failFastOnUnexpectedRequest = true;

    public DefaultClientDriverJettyHandler(RequestMatcher matcher) {
        this.matcher = matcher;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.info("Handling: {} {}", (Object)request.getMethod(), (Object)request.getPathInfo());
        ClientDriverRequestResponsePair matchingPair = this.getMatchingRequestPair(request);
        if (matchingPair != null) {
            this.matchedResponses.add(matchingPair);
            ClientDriverResponse matchedResponse = matchingPair.getResponse();
            response.setContentType(matchedResponse.getContentType());
            response.setStatus(matchedResponse.getStatus());
            response.setHeader("Server", "rest-client-driver(" + RestDriverProperties.getVersion() + ")");
            for (Map.Entry<String, String> thisHeader : matchedResponse.getHeaders().entrySet()) {
                response.setHeader(thisHeader.getKey(), thisHeader.getValue());
            }
            if (matchedResponse.hasBody()) {
                ServletOutputStream output = response.getOutputStream();
                output.write(matchedResponse.getContentAsBytes());
            }
            this.delayIfNecessary(matchingPair.getResponse());
        } else {
            response.setStatus(404);
        }
        baseRequest.setHandled(true);
    }

    private void delayIfNecessary(ClientDriverResponse response) {
        if (response.getDelayTime() > 0L) {
            try {
                response.getDelayTimeUnit().sleep(response.getDelayTime());
            }
            catch (InterruptedException ie) {
                throw new ClientDriverInternalException("Requested delay was interrupted", ie);
            }
        }
    }

    private synchronized ClientDriverRequestResponsePair getMatchingRequestPair(HttpServletRequest request) {
        int index;
        ClientDriverExpectation matchedExpectation = null;
        HttpRealRequest realRequest = new HttpRealRequest(request);
        for (index = 0; index < this.expectations.size(); ++index) {
            ClientDriverExpectation thisExpectation = this.expectations.get(index);
            ClientDriverRequestResponsePair thisPair = thisExpectation.getPair();
            if (!this.matcher.isMatch(realRequest, thisPair.getRequest())) continue;
            thisExpectation.match(realRequest);
            matchedExpectation = thisExpectation;
            break;
        }
        if (matchedExpectation == null) {
            this.unexpectedRequests.add(new HttpRealRequest(request));
            if (this.failFastOnUnexpectedRequest) {
                throw new ClientDriverFailedExpectationException(this.unexpectedRequests, this.expectations);
            }
            return null;
        }
        if (matchedExpectation.isSatisfied()) {
            this.expectations.remove(index);
        }
        this.captureBodyIfRequired(realRequest, matchedExpectation);
        return matchedExpectation.getPair();
    }

    private void captureBodyIfRequired(HttpRealRequest realRequest, ClientDriverExpectation matchedExpectation) {
        ClientDriverRequest request = matchedExpectation.getPair().getRequest();
        if (request.getBodyCapture() != null) {
            request.getBodyCapture().setBody(realRequest.getBodyContent());
        }
    }

    @Override
    public void checkForUnexpectedRequests() {
        if (!this.unexpectedRequests.isEmpty()) {
            throw new ClientDriverFailedExpectationException(this.unexpectedRequests, this.expectations);
        }
    }

    @Override
    public void checkForUnmatchedExpectations() {
        if (this.expectations.isEmpty()) {
            return;
        }
        long period = 0L;
        ArrayList failedExpectations = Lists.newArrayList();
        block0: do {
            if (period > 0L) {
                this.waitFor(period);
                period = 0L;
            }
            for (ClientDriverExpectation expectation : this.expectations) {
                if (expectation.shouldMatchAnyTimes()) continue;
                ClientDriverResponse response = expectation.getPair().getResponse();
                if (response.canExpire() && response.hasNotExpired()) {
                    period = 500L;
                    continue block0;
                }
                failedExpectations.add(expectation);
            }
        } while (period > 0L);
        if (!failedExpectations.isEmpty()) {
            throw new ClientDriverFailedExpectationException(failedExpectations);
        }
    }

    @Override
    public void noFailFastOnUnexpectedRequest() {
        this.failFastOnUnexpectedRequest = false;
    }

    @Override
    public void reset() {
        this.expectations.clear();
        this.matchedResponses.clear();
        this.unexpectedRequests.clear();
        this.failFastOnUnexpectedRequest = true;
    }

    private void waitFor(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ie) {
            throw new ClientDriverInternalException("Waiting for requests was interrupted", ie);
        }
    }

    @Override
    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        ClientDriverRequestResponsePair pair = new ClientDriverRequestResponsePair(request, response);
        ClientDriverExpectation expectation = new ClientDriverExpectation(pair);
        this.expectations.add(expectation);
        return expectation;
    }
}

