/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.exception.ClientDriverResponseCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public final class ClientDriverResponse {
    private static final int DEFAULT_STATUS_CODE = 200;
    private static final int EMPTY_RESPONSE_CODE = 204;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";
    private int status;
    private final byte[] content;
    private String contentType;
    private final Map<String, String> headers;
    private long delayTime;
    private TimeUnit delayTimeUnit = TimeUnit.SECONDS;
    private long waitUntil;

    public ClientDriverResponse() {
        this((String)null, null);
    }

    @Deprecated
    public ClientDriverResponse(String content) {
        this(ClientDriverResponse.convertStringToByteArray(content), DEFAULT_TEXT_CONTENT_TYPE);
    }

    public ClientDriverResponse(String content, String contentType) {
        this(ClientDriverResponse.convertStringToByteArray(content), contentType);
    }

    public ClientDriverResponse(InputStream content, String contentType) {
        this(ClientDriverResponse.convertInputStreamToByteArray(content), contentType);
    }

    private ClientDriverResponse(byte[] content, String contentType) {
        this.status = ClientDriverResponse.statusCodeForContent(content);
        this.content = content;
        this.contentType = content != null && content.length != 0 ? contentType : null;
        this.headers = new HashMap<String, String>();
    }

    private static byte[] convertStringToByteArray(String content) {
        return content != null ? content.getBytes() : null;
    }

    private static byte[] convertInputStreamToByteArray(InputStream content) {
        try {
            return content != null ? IOUtils.toByteArray((InputStream)content) : null;
        }
        catch (IOException e) {
            throw new ClientDriverResponseCreationException("unable to create client driver response", e);
        }
    }

    private static int statusCodeForContent(byte[] content) {
        return content != null ? 200 : 204;
    }

    public byte[] getContentAsBytes() {
        if (this.content == null || this.content.length == 0) {
            return null;
        }
        return this.content;
    }

    public String getContent() {
        if (this.getContentAsBytes() == null) {
            return "";
        }
        return new String(this.content);
    }

    public ClientDriverResponse withStatus(int withStatus) {
        this.status = withStatus;
        return this;
    }

    public ClientDriverResponse after(long delay, TimeUnit timeUnit) {
        this.delayTime = delay;
        this.delayTimeUnit = timeUnit;
        return this;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public TimeUnit getDelayTimeUnit() {
        return this.delayTimeUnit;
    }

    public boolean canExpire() {
        return this.waitUntil != 0L;
    }

    public boolean hasNotExpired() {
        return this.waitUntil > System.currentTimeMillis();
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Deprecated
    public ClientDriverResponse withContentType(String withContentType) {
        this.contentType = withContentType;
        return this;
    }

    public ClientDriverResponse withHeader(String name, String value) {
        if (CONTENT_TYPE.equalsIgnoreCase(name)) {
            this.contentType = value;
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    public ClientDriverResponse within(long interval, TimeUnit unit) {
        this.waitUntil = System.currentTimeMillis() + unit.toMillis(interval);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean hasBody() {
        return this.content != null && this.content.length != 0;
    }
}

