/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RealRequest;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpRealRequest
implements RealRequest {
    private final ClientDriverRequest.Method method;
    private final String path;
    private final Multimap<String, String> params;
    private final Map<String, Object> headers;
    private final byte[] bodyContent;
    private final String bodyContentType;

    public HttpRealRequest(HttpServletRequest request) {
        this.path = request.getPathInfo();
        this.method = ClientDriverRequest.Method.custom(request.getMethod().toUpperCase());
        this.params = HashMultimap.create();
        if (request.getQueryString() != null) {
            MultiMap parameterMap = new MultiMap();
            UrlEncoded.decodeTo((String)request.getQueryString(), (MultiMap)parameterMap, (Charset)StandardCharsets.UTF_8);
            for (Map.Entry paramEntry : parameterMap.toStringArrayMap().entrySet()) {
                String[] values;
                for (String value : values = (String[])paramEntry.getValue()) {
                    this.params.put((Object)((String)paramEntry.getKey()), (Object)value);
                }
            }
        }
        this.headers = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                this.headers.put(headerName.toLowerCase(), request.getHeader(headerName));
            }
        }
        try {
            this.bodyContent = IOUtils.toByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read body of request", e);
        }
        this.bodyContentType = request.getContentType();
    }

    @Override
    public final ClientDriverRequest.Method getMethod() {
        return this.method;
    }

    @Override
    public final String getPath() {
        return this.path;
    }

    @Override
    public final Map<String, Collection<String>> getParams() {
        return Collections.unmodifiableMap(this.params.asMap());
    }

    @Override
    public final Map<String, Object> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public final byte[] getBodyContent() {
        return this.bodyContent;
    }

    @Override
    public final String getBodyContentType() {
        return this.bodyContentType;
    }

    public String toString() {
        String paramsJoined = Joiner.on((String)",").withKeyValueSeparator("=").useForNull("<null>").join(this.params.asMap());
        String headersJoined = Joiner.on((String)",").withKeyValueSeparator(": ").useForNull("<null>").join(this.headers);
        return "HttpRealRequest: " + this.method + " " + this.path + "; PARAMS: [" + paramsJoined + "]; HEADERS: [" + headersJoined + "]; CONTENT TYPE " + this.bodyContentType + "; BODY " + new String(this.bodyContent) + ";";
    }
}

