/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriver;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.security.KeyStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecureClientDriver
extends ClientDriver {
    KeyStore keyStore;
    String password;
    String certificateAlias;

    public SecureClientDriver(ClientDriverJettyHandler handler, int port, KeyStore keyStore, String password, String certificateAlias) {
        this.keyStore = keyStore;
        this.password = password;
        this.certificateAlias = certificateAlias;
        this.handler = handler;
        this.jettyServer = this.createAndStartJetty(port);
    }

    public SecureClientDriver(ClientDriverJettyHandler handler, KeyStore keyStore, String password, String certificateAlias) {
        this(handler, 0, keyStore, password, certificateAlias);
    }

    @Override
    protected SslContextFactory getSslContextFactory() {
        SslContextFactory sslContextFactoryFactory = new SslContextFactory();
        sslContextFactoryFactory.setKeyStore(this.keyStore);
        sslContextFactoryFactory.setCertAlias(this.certificateAlias);
        sslContextFactoryFactory.setKeyStorePassword(this.password);
        return sslContextFactoryFactory;
    }

    @Override
    public String getBaseUrl() {
        return "https://localhost:" + this.getPort();
    }
}

