/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ContainingValue
extends TypeSafeMatcher<JsonNode> {
    private final Matcher<?> matcher;

    public ContainingValue(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("A JSON array containing: ");
        this.matcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode node) {
        if (!node.isArray()) {
            return false;
        }
        Iterator nodeIterator = node.elements();
        while (nodeIterator.hasNext()) {
            String value = ((JsonNode)nodeIterator.next()).textValue();
            if (!this.matcher.matches((Object)value)) continue;
            return true;
        }
        return false;
    }
}

