/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.restdriver.exception.RuntimeJsonTypeMismatchException;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HasJsonPath<T>
extends TypeSafeMatcher<JsonNode> {
    private final String jsonPath;
    private final Matcher<T> matcher;

    public HasJsonPath(String jsonPath) {
        this(jsonPath, null);
    }

    public HasJsonPath(String jsonPath, Matcher<T> matcher) {
        this.jsonPath = jsonPath;
        this.matcher = matcher;
    }

    public boolean matchesSafely(JsonNode jsonNode) {
        Object jsonPathResult = null;
        try {
            jsonPathResult = JsonPath.read((String)jsonNode.toString(), (String)this.jsonPath, (Filter[])new Filter[0]);
            if (this.matcher == null) {
                return jsonPathResult != null;
            }
            boolean initialMatchResult = this.matcher.matches(jsonPathResult);
            if (!initialMatchResult && jsonPathResult instanceof Integer) {
                return this.matcher.matches((Object)this.intToLong(jsonPathResult));
            }
            return initialMatchResult;
        }
        catch (InvalidPathException e) {
            return false;
        }
        catch (ClassCastException cce) {
            if (this.matcher.matches((Object)this.intToLong(jsonPathResult))) {
                return true;
            }
            throw new RuntimeJsonTypeMismatchException("JSONpath returned a type unsuitable for matching with the given matcher: " + cce.getMessage(), cce);
        }
    }

    private long intToLong(Object o) {
        int i;
        try {
            i = (Integer)o;
        }
        catch (ClassCastException cce) {
            throw new RuntimeJsonTypeMismatchException("JSONpath returned a type unsuitable for matching with the given matcher: " + cce.getMessage(), cce);
        }
        return i;
    }

    public void describeTo(Description description) {
        description.appendText("a JSON object matching JSONpath \"" + this.jsonPath + "\"");
        if (this.matcher != null) {
            description.appendText(" with ");
            this.matcher.describeTo(description);
        }
    }
}

