/*
 * Decompiled with CFR 0.152.
 */
package com.rey.mvp.impl;

import android.os.Bundle;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.util.SparseArrayCompat;
import com.rey.mvp.Presenter;
import com.rey.mvp.PresenterCache;
import com.rey.mvp.ViewState;
import com.rey.mvp.ViewStateCache;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class MvpActivityDelegate
implements PresenterCache,
ViewStateCache {
    private static final String KEY_NEXT_PRESENTER_ID = "com.rey.mvp.next_presenter_id";
    private static final String KEY_VIEW_STATE_TAG = "com.rey.mvp.view_state_tag";
    private static final String KEY_VIEW_STATE_DATA = "com.rey.mvp.view_state_data";
    private PersistentInstance mPersistentInstance;

    public void onCreate(Bundle savedInstanceState, Object persistentObj) {
        this.mPersistentInstance = (PersistentInstance)persistentObj;
        if (this.mPersistentInstance == null) {
            int seed = savedInstanceState == null ? 0 : savedInstanceState.getInt(KEY_NEXT_PRESENTER_ID);
            this.mPersistentInstance = new PersistentInstance(seed);
            if (savedInstanceState != null) {
                try {
                    String[] tags = savedInstanceState.getStringArray(KEY_VIEW_STATE_TAG);
                    String[] data = savedInstanceState.getStringArray(KEY_VIEW_STATE_DATA);
                    if (tags != null) {
                        for (int i = 0; i < tags.length; ++i) {
                            this.mPersistentInstance.mViewStatesData.put((Object)tags[i], (Object)data[i]);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putLong(KEY_NEXT_PRESENTER_ID, (long)this.mPersistentInstance.mNextPresenterId.get());
        Set set = this.mPersistentInstance.mViewStatesData.keySet();
        String[] tags = new String[set.size()];
        String[] data = new String[tags.length];
        Iterator iter = set.iterator();
        int index = 0;
        while (iter.hasNext()) {
            tags[index] = (String)iter.next();
            data[index] = (String)this.mPersistentInstance.mViewStatesData.get((Object)tags[index]);
            ++index;
        }
        outState.putStringArray(KEY_VIEW_STATE_TAG, tags);
        outState.putStringArray(KEY_VIEW_STATE_DATA, data);
    }

    public Object getPersistentObject() {
        return this.mPersistentInstance;
    }

    @Override
    public int generatePresenterId() {
        return this.mPersistentInstance.mNextPresenterId.getAndIncrement();
    }

    @Override
    public <P extends Presenter> P getPresenter(int id) {
        Presenter p;
        try {
            p = (Presenter)this.mPersistentInstance.mPresenters.get(id);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        return (P)p;
    }

    @Override
    public void setPresenter(int id, Presenter presenter) {
        if (presenter == null) {
            this.mPersistentInstance.mPresenters.remove(id);
        } else {
            this.mPersistentInstance.mPresenters.put(id, (Object)presenter);
        }
    }

    @Override
    public <S extends ViewState> S getViewState(String tag) {
        ViewState s;
        ViewState temp = (ViewState)this.mPersistentInstance.mViewStates.get((Object)tag);
        if (temp == null) {
            return null;
        }
        try {
            s = temp;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        return (S)s;
    }

    @Override
    public void addViewState(ViewState viewState) {
        this.mPersistentInstance.mViewStates.put((Object)viewState.getTag(), (Object)viewState);
    }

    @Override
    public void saveViewStateData(ViewState viewState) {
        String state = viewState.onSave();
        if (state != null) {
            this.mPersistentInstance.mViewStatesData.put((Object)viewState.getTag(), (Object)state);
        }
    }

    @Override
    public void restoreViewStateData(ViewState viewState) {
        String state = (String)this.mPersistentInstance.mViewStatesData.get((Object)viewState.getTag());
        if (state != null) {
            viewState.onRestore(state);
        }
    }

    @Override
    public void removeViewState(ViewState viewState) {
        String tag = viewState.getTag();
        this.mPersistentInstance.mViewStates.remove((Object)tag);
        this.mPersistentInstance.mViewStatesData.remove((Object)tag);
    }

    private static class PersistentInstance {
        private SparseArrayCompat<Presenter> mPresenters = new SparseArrayCompat();
        private AtomicInteger mNextPresenterId;
        private SimpleArrayMap<String, ViewState> mViewStates;
        private ArrayMap<String, String> mViewStatesData;

        public PersistentInstance(int seed) {
            this.mNextPresenterId = new AtomicInteger(seed);
            this.mViewStates = new SimpleArrayMap();
            this.mViewStatesData = new ArrayMap();
        }
    }
}

