/*
 * Decompiled with CFR 0.152.
 */
package com.rey.mvp.impl;

import android.os.Bundle;
import com.rey.mvp.Presenter;
import com.rey.mvp.PresenterCache;
import com.rey.mvp.PresenterFactory;
import com.rey.mvp.ViewState;
import com.rey.mvp.ViewStateCache;
import com.rey.mvp.ViewStateFactory;
import java.lang.ref.WeakReference;

public class MvpDelegate<V, P extends Presenter<V, S>, S extends ViewState> {
    private static final String KEY_PRESENTER_ID = "com.rey.mvp.presenter_id";
    private int mPresenterId;
    private WeakReference<PresenterCache> mPresenterCacheRef;
    private WeakReference<ViewStateCache> mViewStateCacheRef;
    private P mPresenter;
    private S mViewState;
    private boolean mIsDestroyedBySystem;

    public void onCreate(PresenterCache presenterCache, ViewStateCache viewStateCache, Bundle savedInstanceState, PresenterFactory<P> presenterFactory, ViewStateFactory<S> viewStateFactory) {
        this.mPresenterCacheRef = new WeakReference<PresenterCache>(presenterCache);
        this.mViewStateCacheRef = new WeakReference<ViewStateCache>(viewStateCache);
        String viewStateTag = viewStateFactory.getViewStateTag();
        this.mViewState = viewStateCache.getViewState(viewStateTag);
        if (this.mViewState == null) {
            this.mViewState = viewStateFactory.createViewState();
            this.mViewState.setTag(viewStateTag);
            viewStateCache.restoreViewStateData((ViewState)this.mViewState);
            viewStateCache.addViewState((ViewState)this.mViewState);
        }
        this.mPresenterId = savedInstanceState == null ? presenterCache.generatePresenterId() : savedInstanceState.getInt(KEY_PRESENTER_ID);
        this.mPresenter = presenterCache.getPresenter(this.mPresenterId);
        if (this.mPresenter == null) {
            this.mPresenter = presenterFactory.createPresenter();
            presenterCache.setPresenter(this.mPresenterId, (Presenter)this.mPresenter);
            this.mPresenter.onCreate(this.mViewState);
        }
        this.mViewState.onBind((Presenter)this.mPresenter);
    }

    public void onViewCreated(V view) {
        this.mPresenter.onAttachView(view);
    }

    public void onDestroyView() {
        this.mPresenter.onDetachView();
    }

    public void onResume() {
        this.mIsDestroyedBySystem = false;
        this.mPresenter.onViewVisible();
    }

    public void onPause() {
        this.mPresenter.onViewHide();
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mIsDestroyedBySystem = true;
        outState.putLong(KEY_PRESENTER_ID, (long)this.mPresenterId);
        ViewStateCache cache = (ViewStateCache)this.mViewStateCacheRef.get();
        if (cache != null) {
            cache.saveViewStateData((ViewState)this.mViewState);
        }
    }

    public void onDestroy() {
        if (!this.mIsDestroyedBySystem) {
            ViewStateCache cache;
            PresenterCache presenterCache = (PresenterCache)this.mPresenterCacheRef.get();
            if (presenterCache != null) {
                presenterCache.setPresenter(this.mPresenterId, null);
            }
            this.mPresenter.onDestroy();
            if (this.mViewState.onUnbind((Presenter)this.mPresenter) && (cache = (ViewStateCache)this.mViewStateCacheRef.get()) != null) {
                cache.removeViewState((ViewState)this.mViewState);
            }
        }
    }

    public P getPresenter() {
        return this.mPresenter;
    }

    public boolean isDestroyedBySystem() {
        return this.mIsDestroyedBySystem;
    }
}

