/*
 * Decompiled with CFR 0.152.
 */
package com.rey.mvp.impl;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.rey.mvp.CacheFactory;
import com.rey.mvp.Presenter;
import com.rey.mvp.PresenterFactory;
import com.rey.mvp.ViewState;
import com.rey.mvp.ViewStateFactory;
import com.rey.mvp.impl.MvpDelegate;

public abstract class MvpFragment<V, P extends Presenter<V, S>, S extends ViewState>
extends Fragment {
    private MvpDelegate<V, P, S> mMvpDelegate = new MvpDelegate();
    private PresenterFactory<P> mPresenterFactory = new PresenterFactory<P>(){

        @Override
        @NonNull
        public P createPresenter() {
            return MvpFragment.this.onCreatePresenter();
        }
    };
    protected ViewStateFactory<S> mViewStateFactory = new ViewStateFactory<S>(){

        @Override
        @NonNull
        public S createViewState() {
            return MvpFragment.this.onCreateViewState();
        }

        @Override
        public String getViewStateTag() {
            return this.getViewStateTag();
        }
    };

    protected CacheFactory getCacheFactory() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof CacheFactory) {
            return (CacheFactory)activity;
        }
        throw new RuntimeException(((Object)((Object)this)).getClass() + " must be attached to " + "an Activity that implements " + CacheFactory.class);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CacheFactory cacheFactory = this.getCacheFactory();
        this.mMvpDelegate.onCreate(cacheFactory.getPresenterCache(), cacheFactory.getViewStateCache(), savedInstanceState, this.mPresenterFactory, this.mViewStateFactory);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mMvpDelegate.onViewCreated(this.getViewImpl());
    }

    public void onResume() {
        super.onResume();
        this.mMvpDelegate.onResume();
    }

    public void onPause() {
        super.onPause();
        this.mMvpDelegate.onPause();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mMvpDelegate.onSaveInstanceState(outState);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mMvpDelegate.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mMvpDelegate.onDestroy();
    }

    @NonNull
    public abstract P onCreatePresenter();

    @NonNull
    public abstract S onCreateViewState();

    @NonNull
    public abstract String getViewStateTag();

    public P getPresenter() {
        return this.mMvpDelegate.getPresenter();
    }

    protected boolean isDestroyedBySystem() {
        return this.mMvpDelegate.isDestroyedBySystem();
    }

    public V getViewImpl() {
        MvpFragment v;
        try {
            v = this;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        return (V)((Object)v);
    }
}

