/*
 * Decompiled with CFR 0.152.
 */
package fr.free.jnizet.retry;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import fr.free.jnizet.retry.Attempt;
import fr.free.jnizet.retry.RetryException;
import fr.free.jnizet.retry.StopStrategy;
import fr.free.jnizet.retry.WaitStrategy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

public final class Retryer<V> {
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final Predicate<Attempt<V>> rejectionPredicate;

    public Retryer(@Nonnull StopStrategy stopStrategy, @Nonnull WaitStrategy waitStrategy, @Nonnull Predicate<Attempt<V>> rejectionPredicate) {
        Preconditions.checkNotNull((Object)stopStrategy, (Object)"stopStrategy may not be null");
        Preconditions.checkNotNull((Object)waitStrategy, (Object)"waitStrategy may not be null");
        Preconditions.checkNotNull(rejectionPredicate, (Object)"waitStrategy may not be null");
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.rejectionPredicate = rejectionPredicate;
    }

    public V call(Callable<V> callable) throws ExecutionException, RetryException {
        long startTime = System.currentTimeMillis();
        int attemptNumber = 1;
        while (true) {
            Attempt<Object> attempt;
            try {
                V result = callable.call();
                attempt = new ResultAttempt<V>(result);
            }
            catch (Throwable t) {
                attempt = new ExceptionAttempt(t);
            }
            if (!this.rejectionPredicate.apply(attempt)) {
                return (V)attempt.get();
            }
            long delaySinceFirstAttemptInMillis = System.currentTimeMillis() - startTime;
            if (this.stopStrategy.shouldStop(attemptNumber, delaySinceFirstAttemptInMillis)) {
                throw new RetryException(attemptNumber, attempt);
            }
            long sleepTime = this.waitStrategy.computeSleepTime(attemptNumber, System.currentTimeMillis() - startTime);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RetryException(attemptNumber, attempt);
            }
            ++attemptNumber;
        }
    }

    public RetryerCallable<V> wrap(Callable<V> callable) {
        return new RetryerCallable(this, callable);
    }

    public static class RetryerCallable<X>
    implements Callable<X> {
        private Retryer<X> retryer;
        private Callable<X> callable;

        private RetryerCallable(Retryer<X> retryer, Callable<X> callable) {
            this.retryer = retryer;
            this.callable = callable;
        }

        @Override
        public X call() throws ExecutionException, RetryException {
            return this.retryer.call(this.callable);
        }
    }

    @Immutable
    private static final class ExceptionAttempt<R>
    implements Attempt<R> {
        private final ExecutionException e;

        public ExceptionAttempt(Throwable cause) {
            this.e = new ExecutionException(cause);
        }

        @Override
        public R get() throws ExecutionException {
            throw this.e;
        }

        @Override
        public boolean hasResult() {
            return false;
        }

        @Override
        public boolean hasException() {
            return true;
        }

        @Override
        public R getResult() throws IllegalStateException {
            throw new IllegalStateException("The attempt resulted in an exception, not in a result");
        }

        @Override
        public Throwable getExceptionCause() throws IllegalStateException {
            return this.e.getCause();
        }
    }

    @Immutable
    private static final class ResultAttempt<R>
    implements Attempt<R> {
        private final R result;

        public ResultAttempt(R result) {
            this.result = result;
        }

        @Override
        public R get() throws ExecutionException {
            return this.result;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean hasException() {
            return false;
        }

        @Override
        public R getResult() throws IllegalStateException {
            return this.result;
        }

        @Override
        public Throwable getExceptionCause() throws IllegalStateException {
            throw new IllegalStateException("The attempt resulted in a result, not in an exception");
        }
    }
}

