/*
 * Decompiled with CFR 0.152.
 */
package com.github.rholder.nilsimsa;

import java.util.Arrays;

public class Nilsimsa {
    public static final int[] TRAN53 = new int[]{2, 214, 158, 111, 249, 29, 4, 171, 208, 34, 22, 31, 216, 115, 161, 172, 59, 112, 98, 150, 30, 110, 143, 57, 157, 5, 20, 74, 166, 190, 174, 14, 207, 185, 156, 154, 199, 104, 19, 225, 45, 164, 235, 81, 141, 100, 107, 80, 35, 128, 3, 65, 236, 187, 113, 204, 122, 134, 127, 152, 242, 54, 94, 238, 142, 206, 79, 184, 50, 182, 95, 89, 220, 27, 49, 76, 123, 240, 99, 1, 108, 186, 7, 232, 18, 119, 73, 60, 218, 70, 254, 47, 121, 28, 155, 48, 227, 0, 6, 126, 46, 15, 56, 51, 33, 173, 165, 84, 202, 167, 41, 252, 90, 71, 105, 125, 197, 149, 181, 244, 11, 144, 163, 129, 109, 37, 85, 53, 245, 117, 116, 10, 38, 191, 25, 92, 26, 198, 255, 153, 93, 132, 170, 102, 62, 175, 120, 179, 32, 67, 193, 237, 36, 234, 230, 63, 24, 243, 160, 66, 87, 8, 83, 96, 195, 192, 131, 64, 130, 215, 9, 189, 68, 42, 103, 168, 147, 224, 194, 86, 159, 217, 221, 133, 21, 180, 138, 39, 40, 146, 118, 222, 239, 248, 178, 183, 201, 61, 69, 148, 75, 17, 13, 101, 213, 52, 139, 145, 12, 250, 135, 233, 124, 91, 177, 77, 229, 212, 203, 16, 162, 23, 137, 188, 219, 176, 226, 151, 136, 82, 247, 72, 211, 97, 44, 58, 43, 209, 140, 251, 241, 205, 228, 106, 231, 169, 253, 196, 55, 200, 210, 246, 223, 88, 114, 78};
    public static final int[] POPC = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private int[] transitions;
    private long count;
    private int[] acc;
    private int[] window;

    public Nilsimsa(int[] transitions) {
        this.transitions = transitions;
        this.count = 0L;
        this.acc = new int[256];
        this.window = new int[4];
        Arrays.fill(this.window, -1);
    }

    public Nilsimsa() {
        this(TRAN53);
    }

    public Nilsimsa update(byte[] data) {
        for (byte character : data) {
            int ch = character & 0xFF;
            ++this.count;
            if (this.window[1] > -1) {
                int n = this.tran3(ch, this.window[0], this.window[1], 0);
                this.acc[n] = this.acc[n] + 1;
            }
            if (this.window[2] > -1) {
                int n = this.tran3(ch, this.window[0], this.window[2], 1);
                this.acc[n] = this.acc[n] + 1;
                int n2 = this.tran3(ch, this.window[1], this.window[2], 2);
                this.acc[n2] = this.acc[n2] + 1;
            }
            if (this.window[3] > -1) {
                int n = this.tran3(ch, this.window[0], this.window[3], 3);
                this.acc[n] = this.acc[n] + 1;
                int n3 = this.tran3(ch, this.window[1], this.window[3], 4);
                this.acc[n3] = this.acc[n3] + 1;
                int n4 = this.tran3(ch, this.window[2], this.window[3], 5);
                this.acc[n4] = this.acc[n4] + 1;
                int n5 = this.tran3(this.window[3], this.window[0], ch, 6);
                this.acc[n5] = this.acc[n5] + 1;
                int n6 = this.tran3(this.window[3], this.window[2], ch, 7);
                this.acc[n6] = this.acc[n6] + 1;
            }
            this.window[3] = this.window[2];
            this.window[2] = this.window[1];
            this.window[1] = this.window[0];
            this.window[0] = ch;
        }
        return this;
    }

    public int[] digest() {
        long total = 0L;
        if (this.count == 3L) {
            total = 1L;
        } else if (this.count == 4L) {
            total = 4L;
        } else if (this.count > 4L) {
            total = 8L * this.count - 28L;
        }
        long threshold = total / 256L;
        int[] code = new int[32];
        for (int i = 0; i < 256; ++i) {
            if ((long)this.acc[i] <= threshold) continue;
            int n = i >> 3;
            code[n] = code[n] + (1 << (i & 7));
        }
        Nilsimsa.unsafeReverse(code);
        return code;
    }

    public String toHexDigest() {
        StringBuilder b = new StringBuilder();
        for (int d : this.digest()) {
            if (d < 16) {
                b.append("0");
            }
            b.append(Integer.toHexString(d));
        }
        return b.toString();
    }

    private int tran3(int a, int b, int c, int n) {
        return (this.transitions[a + n & 0xFF] ^ this.transitions[b] * (n + n + 1)) + this.transitions[c ^ this.transitions[n]] & 0xFF;
    }

    public static void unsafeReverse(int[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static int compare(String digest1, String digest2) {
        return Nilsimsa.compare(Nilsimsa.unsafeToHex(digest1), Nilsimsa.unsafeToHex(digest2));
    }

    public static int[] unsafeToHex(String s) {
        int len = s.length();
        int[] data = new int[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16);
        }
        return data;
    }

    public static int compare(int[] digest1, int[] digest2) {
        int bits = 0;
        for (int i = 0; i < 32; ++i) {
            bits += POPC[0xFF & (digest1[i] ^ digest2[i])];
        }
        return 128 - bits;
    }

    public static int[] generateTransitions(int target) {
        int[] tran = new int[256];
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            j = j * target + 1 & 0xFF;
            if ((j += j) > 255) {
                j -= 255;
            }
            for (int k = 0; k < i; ++k) {
                if (j != tran[k]) continue;
                j = j + 1 & 0xFF;
                k = 0;
            }
            tran[i] = j;
        }
        return tran;
    }
}

