/*
 * Decompiled with CFR 0.152.
 */
package com.comparator;

import com.comparator.ComparatorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class Comparator<T, K> {
    private List<ComparatorItem> items;
    private T value;

    private Comparator(T value) {
        this.value = value;
        this.items = new ArrayList<ComparatorItem>();
    }

    public static <T, K> Comparator<T, K> of(T value) {
        return new Comparator<T, K>(value);
    }

    public static <T, U> Comparator<T, U> of(T value, Class<U> resultObjectClass) {
        if (resultObjectClass == null) {
            throw new NoSuchElementException("returnObjectClass couldn't be null");
        }
        return new Comparator(value);
    }

    public Comparator<T, K> compare(Predicate<? super T> condition, Function<T, K> resultExpression) {
        if (condition == null) {
            throw new NoSuchElementException("No condition present");
        }
        if (resultExpression == null) {
            throw new NoSuchElementException("No mapping function present");
        }
        this.items.add(new ComparatorItem<T, K>(this.value, condition, resultExpression));
        return this;
    }

    public <U> Comparator<T, K> compare(Object expectedValue, Function<? super T, ? extends U> resultExpression) {
        if (resultExpression == null) {
            throw new NoSuchElementException("No mapping function present");
        }
        this.items.add(new ComparatorItem<T, U>(this.value, s -> s.equals(expectedValue), resultExpression));
        return this;
    }

    public Comparator<T, K> compare(Object expectedValue, Object resultValue) {
        this.items.add(new ComparatorItem<Object, Object>(this.value, s -> s.equals(expectedValue), s -> resultValue));
        return this;
    }

    private Object get(Object defaultValue) {
        for (ComparatorItem item : this.items) {
            Optional optional = Optional.ofNullable(item.getValue());
            Object obj = optional.filter(item.getCondition()).map(item.getResultExpression()).orElse(null);
            if (obj == null) continue;
            return obj;
        }
        return defaultValue;
    }

    public <U> U orElse(U value) {
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return (U)this.get(value);
    }

    public <U> U get() {
        return (U)this.get(null);
    }
}

