/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.comparator.Comparator;
import com.jfilter.filter.DynamicFilter;
import com.jfilter.filter.DynamicFilterComponent;
import com.jfilter.filter.DynamicFilterEvent;
import com.jfilter.filter.FilterFields;
import com.jfilter.request.RequestSession;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;

@Component
public final class DynamicFilterProvider {
    private ApplicationContext applicationContext;
    private Map<Class, DynamicFilterEvent> dynamicFilterMap;

    @Autowired
    public DynamicFilterProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.dynamicFilterMap = new HashMap<Class, DynamicFilterEvent>();
        this.findDynamicFilters();
    }

    private void findDynamicFilters() {
        Map beans = this.applicationContext.getBeansWithAnnotation(DynamicFilterComponent.class);
        beans.forEach((k, v) -> {
            if (DynamicFilterEvent.class.isInstance(v)) {
                this.dynamicFilterMap.put(v.getClass(), (DynamicFilterEvent)v);
            }
        });
    }

    public static boolean isAccept(MethodParameter methodParameter) {
        return methodParameter.getMethod().getDeclaredAnnotation(DynamicFilter.class) != null;
    }

    public FilterFields getFields(MethodParameter methodParameter, RequestSession request) {
        DynamicFilter dynamicFilterAnnotation = methodParameter.getMethod().getDeclaredAnnotation(DynamicFilter.class);
        if (dynamicFilterAnnotation != null && this.dynamicFilterMap.containsKey(dynamicFilterAnnotation.value())) {
            DynamicFilterEvent filter = this.dynamicFilterMap.get(dynamicFilterAnnotation.value());
            Comparator comparator = Comparator.of((Object)request, FilterFields.class);
            filter.onRequest((Comparator<RequestSession, FilterFields>)comparator);
            return (FilterFields)comparator.orElse((Object)FilterFields.EMPTY_FIELDS);
        }
        return new FilterFields();
    }
}

