/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.jfilter.FileWatcherEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@EnableScheduling
@Controller
public class FileWatcher
implements DisposableBean {
    private static final Long FILE_MODIFY_THRESHOLD = 1000L;
    private static final String FILE_MODIFY_DELAY = "2000";
    private WatchService watcher = FileSystems.getDefault().newWatchService();
    private Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private Map<File, FileRecord> fileRecords = new HashMap<File, FileRecord>();
    private boolean closed = false;
    private boolean overflowed = false;

    public boolean add(File file, FileWatcherEvent event) {
        if (file == null || !file.exists()) {
            return false;
        }
        this.fileRecords.put(file, new FileRecord(file, event));
        try {
            Path path;
            Path path2 = path = file.isDirectory() ? Paths.get(file.getPath(), new String[0]) : Paths.get(file.getParent(), new String[0]);
            if (!this.watchKeys.containsValue(path)) {
                this.watchKeys.put(path.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY), path);
                return true;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean fileIsModified(File file) {
        boolean result = false;
        if (this.fileRecords.containsKey(file)) {
            FileRecord record = this.fileRecords.get(file);
            Long lastModified = record.getLastModified();
            if (file.lastModified() - lastModified > FILE_MODIFY_THRESHOLD) {
                record.setLastModified(file.lastModified());
                result = true;
            }
        }
        return result;
    }

    private void processModifiedFiles() throws InterruptedException {
        WatchKey key = this.watcher.take();
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                this.overflowed = true;
                continue;
            }
            if (!this.watchKeys.containsKey(key)) continue;
            WatchEvent<?> ev = event;
            String filename = String.format("%s%s%s", this.watchKeys.get(key).toString(), File.separator, ((Path)ev.context()).toString());
            File file = new File(filename);
            if (!this.fileIsModified(file)) continue;
            this.fileRecords.get(file).onEvent();
        }
        key.reset();
    }

    @Scheduled(fixedDelayString="2000")
    public void scheduleModifiedFiles() {
        try {
            if (!this.closed) {
                this.processModifiedFiles();
            }
        }
        catch (ClosedWatchServiceException e) {
            this.closed = true;
        }
        catch (InterruptedException e) {
            this.closed = true;
            Thread.currentThread().interrupt();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public WatchService getWatcher() {
        return this.watcher;
    }

    public void destroy() throws IOException {
        if (!this.closed) {
            this.watcher.close();
            this.closed = true;
        }
    }

    public boolean isOverflowed() {
        return this.overflowed;
    }

    public static class FileRecord {
        private final File file;
        private final FileWatcherEvent event;
        private Long lastModified;

        public FileRecord(File file, FileWatcherEvent event) {
            this.file = file;
            this.event = event;
            this.lastModified = file.lastModified();
        }

        public Long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }

        public boolean onEvent() {
            if (this.event != null) {
                this.event.onEvent(this.file);
                return true;
            }
            return false;
        }
    }
}

