/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.jfilter.components.DynamicFilterProvider;
import com.jfilter.components.FilterConfiguration;
import com.jfilter.components.FilterProvider;
import com.jfilter.converter.FilterClassWrapper;
import com.jfilter.converter.MethodParameterDetails;
import com.jfilter.filter.BaseFilter;
import com.jfilter.filter.FilterFields;
import com.jfilter.request.RequestSession;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public final class FilterAdvice
implements ResponseBodyAdvice<Object> {
    private FilterProvider filterProvider;
    private DynamicFilterProvider dynamicFilterProvider;
    private FilterConfiguration filterConfiguration;

    @Autowired
    public void setFilterProvider(FilterProvider filterProvider) {
        this.filterProvider = filterProvider;
    }

    @Autowired
    public FilterAdvice setDynamicFilterProvider(DynamicFilterProvider dynamicFilterProvider) {
        this.dynamicFilterProvider = dynamicFilterProvider;
        return this;
    }

    @Autowired
    public FilterAdvice setFilterConfiguration(FilterConfiguration filterConfiguration) {
        this.filterConfiguration = filterConfiguration;
        return this;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return this.filterConfiguration.isEnabled() && (this.filterProvider.isAccept(methodParameter) || DynamicFilterProvider.isAccept(methodParameter));
    }

    public Serializable beforeBodyWrite(Object obj, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        HttpServletRequest servletServerHttpRequest = ((ServletServerHttpRequest)serverHttpRequest).getServletRequest();
        RequestSession requestSession = new RequestSession(servletServerHttpRequest);
        BaseFilter filter = this.filterProvider.getFilter(methodParameter);
        FilterFields filterFields = filter != null ? filter.getFields(obj, requestSession) : this.dynamicFilterProvider.getFields(methodParameter, requestSession);
        MethodParameterDetails methodParameterDetails = new MethodParameterDetails(methodParameter, mediaType, filterFields);
        return new FilterClassWrapper(obj, methodParameterDetails);
    }
}

