/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfilter.components.FilterProvider;
import com.jfilter.components.ObjectMapperCache;
import com.jfilter.converter.SerializationConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class FilterConfiguration {
    private boolean enabled;
    private ConcurrentMap<MediaType, ObjectMapper> mapperList = new ConcurrentHashMap<MediaType, ObjectMapper>();
    private ObjectMapperCache objectMapperCache;
    private SerializationConfig serializationConfig = new SerializationConfig();
    private boolean useDefaultConverters;

    public FilterConfiguration() {
        this.configureDefaultMappers();
    }

    private void configureDefaultMappers() {
        this.setMapper(MediaType.APPLICATION_JSON, Jackson2ObjectMapperBuilder.json().build());
        this.setMapper(MediaType.APPLICATION_JSON_UTF8, Jackson2ObjectMapperBuilder.json().build());
        this.setMapper(new MediaType("application", "json", Charset.defaultCharset()), Jackson2ObjectMapperBuilder.json().build());
        this.setMapper(new MediaType("application", "*+json"), Jackson2ObjectMapperBuilder.json().build());
        this.setMapper(MediaType.APPLICATION_XML, Jackson2ObjectMapperBuilder.xml().build());
        this.setMapper(new MediaType("application", "xml", Charset.defaultCharset()), Jackson2ObjectMapperBuilder.xml().build());
        this.setMapper(new MediaType("application", "*+xml"), Jackson2ObjectMapperBuilder.xml().build());
        this.setMapper(new MediaType("application", "xml"), Jackson2ObjectMapperBuilder.xml().build());
    }

    @Autowired
    private FilterConfiguration setObjectMapperCache(ObjectMapperCache objectMapperCache) {
        this.objectMapperCache = objectMapperCache;
        return this;
    }

    @Autowired
    private FilterConfiguration setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this.enabled = FilterProvider.isFilterEnabled(webApplicationContext);
        return this;
    }

    protected ObjectMapper getMapper(MediaType mediaType) {
        return (ObjectMapper)this.mapperList.get(mediaType);
    }

    public void setMapper(MediaType mediaType, ObjectMapper objectMapper) {
        this.mapperList.put(mediaType, objectMapper);
    }

    protected List<MediaType> supportedMediaTypes() {
        return new ArrayList<MediaType>(this.mapperList.keySet());
    }

    public ObjectMapperCache getObjectMapperCache() {
        return this.objectMapperCache;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FilterConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public boolean isUseDefaultConverters() {
        return this.useDefaultConverters;
    }

    public FilterConfiguration setUseDefaultConverters(boolean useDefaultConverters) {
        this.useDefaultConverters = useDefaultConverters;
        return this;
    }
}

