/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfilter.components.FilterConfiguration;
import com.jfilter.converter.FilterClassWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FilterConverter
extends AbstractHttpMessageConverter<Object> {
    private FilterConfiguration filterConfiguration;

    public FilterConverter(FilterConfiguration filterConfiguration) {
        this.filterConfiguration = filterConfiguration;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.filterConfiguration.supportedMediaTypes();
    }

    public boolean canRead(Class clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class clazz, MediaType mediaType) {
        return this.filterConfiguration.isEnabled() && (this.filterConfiguration.supportedMediaTypes().indexOf(mediaType) >= 0 || Objects.isNull(mediaType));
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        return null;
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (object instanceof FilterClassWrapper) {
            FilterClassWrapper wrapper = (FilterClassWrapper)object;
            ObjectMapper objectMapper = this.filterConfiguration.getObjectMapperCache().findObjectMapper(wrapper.getMethodParameterDetails());
            objectMapper.writeValue(outputMessage.getBody(), wrapper.getObject());
        } else {
            ObjectMapper objectMapper = this.filterConfiguration.getMapper(contentType);
            objectMapper.writeValue(outputMessage.getBody(), object);
        }
    }
}

