/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Serializers;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.jfilter.converter.ConverterMapperModifier;
import com.jfilter.converter.SerializationConfig;
import com.jfilter.filter.FilterFields;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class FilterObjectMapperBuilder {
    private ObjectMapper objectMapper;
    private FilterFields filterFields;
    private SerializationConfig serializationConfig;

    public FilterObjectMapperBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public FilterObjectMapperBuilder withFilterFields(FilterFields filterFields) {
        this.filterFields = filterFields;
        return this;
    }

    public FilterObjectMapperBuilder withSetSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    public ObjectMapper build() {
        BeanSerializerFactory factory;
        Object object = factory = this.filterFields != null ? BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new ConverterMapperModifier(this.filterFields)) : BeanSerializerFactory.instance;
        if (this.serializationConfig.isDefaultSerializersEnabled()) {
            factory.withAdditionalSerializers((Serializers)new SimpleSerializers()).withAdditionalSerializers((Serializers)new Jdk8Serializers()).withAdditionalKeySerializers((Serializers)new SimpleSerializers());
        }
        this.objectMapper.setSerializerFactory((SerializerFactory)factory);
        if (this.serializationConfig.isDateTimeModuleEnabled()) {
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)LocalTimeSerializer.INSTANCE);
            javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)LocalDateSerializer.INSTANCE);
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE);
            javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)LocalTimeDeserializer.INSTANCE);
            javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)LocalDateDeserializer.INSTANCE);
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)LocalDateTimeDeserializer.INSTANCE);
            this.objectMapper.registerModule((Module)javaTimeModule);
            this.objectMapper.findAndRegisterModules();
        }
        return this.objectMapper;
    }
}

