/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.jfilter.EnableJsonFilter;
import com.jfilter.components.FileWatcher;
import com.jfilter.filter.BaseFilter;
import com.jfilter.filter.FileFilter;
import com.jfilter.filter.FilterFactory;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public final class FilterProvider {
    private final Map<Annotation, BaseFilter> filters = new ConcurrentHashMap<Annotation, BaseFilter>();
    private boolean enabled;
    private FileWatcher fileWatcher;

    @Autowired
    public void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this.enabled = FilterProvider.isFilterEnabled(webApplicationContext);
    }

    @Autowired
    public FilterProvider setFileWatcher(FileWatcher fileWatcher) {
        this.fileWatcher = fileWatcher;
        return this;
    }

    public static boolean isFilterEnabled(WebApplicationContext webApplicationContext) {
        return webApplicationContext.getBeansWithAnnotation(EnableJsonFilter.class).size() > 0;
    }

    private BaseFilter getBaseFilter(MethodParameter methodParameter) {
        Annotation key = FilterFactory.getFilterAnnotation(methodParameter);
        if (key != null) {
            if (this.filters.containsKey(key)) {
                return this.filters.get(key);
            }
            BaseFilter filter = FilterFactory.getFromFactory(methodParameter);
            if (filter instanceof FileFilter) {
                ((FileFilter)filter).setFileWatcher(this.fileWatcher);
            }
            this.filters.put(key, filter);
            return filter;
        }
        return null;
    }

    public boolean isAccept(MethodParameter methodParameter) {
        return this.enabled && FilterFactory.isAccept(methodParameter);
    }

    public BaseFilter getFilter(MethodParameter methodParameter) {
        return this.getBaseFilter(methodParameter);
    }

    public void clearCache() {
        this.filters.clear();
    }

    public int cacheSize() {
        return this.filters.size();
    }
}

