/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.components;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfilter.components.FilterConfiguration;
import com.jfilter.components.FilterObjectMapperBuilder;
import com.jfilter.converter.MethodParameterDetails;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectMapperCache {
    private ConcurrentMap<MethodParameterDetails, ObjectMapper> items = new ConcurrentHashMap<MethodParameterDetails, ObjectMapper>();
    private FilterConfiguration filterConfiguration;

    @Autowired
    public ObjectMapperCache setFilterConfiguration(FilterConfiguration filterConfiguration) {
        this.filterConfiguration = filterConfiguration;
        return this;
    }

    public ObjectMapper findObjectMapper(MethodParameterDetails item) {
        ObjectMapper objectMapper = (ObjectMapper)this.items.get(item);
        if (objectMapper == null) {
            objectMapper = this.addNewMapper(item);
        }
        return objectMapper;
    }

    private ObjectMapper addNewMapper(MethodParameterDetails item) {
        ObjectMapper configuredObjectMapper = this.filterConfiguration.getMapper(item.getMediaType()).copy();
        ObjectMapper objectMapper = new FilterObjectMapperBuilder(configuredObjectMapper).withFilterFields(item.getFilterFields()).withSetSerializationConfig(this.filterConfiguration.getSerializationConfig()).build();
        this.items.put(item, objectMapper);
        return objectMapper;
    }
}

