/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.converter;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.jfilter.filter.FilterBehaviour;
import com.jfilter.filter.FilterFields;
import java.util.List;

public class ConverterMapperModifier
extends BeanSerializerModifier {
    private final FilterFields filterFields;

    public ConverterMapperModifier(FilterFields filterFields) {
        this.filterFields = filterFields;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        this.removeFields(beanDesc, beanProperties);
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    private void removeFieldsByClass(Class clazz, List<BeanPropertyWriter> beanProperties) {
        List<String> ignores = this.filterFields.getFields(clazz);
        if (!ignores.isEmpty()) {
            if (this.filterFields.getFilterBehaviour() == FilterBehaviour.HIDE_FIELDS) {
                beanProperties.removeIf(beanProperty -> ignores.contains(beanProperty.getName()));
            } else {
                beanProperties.removeIf(beanProperty -> !ignores.contains(beanProperty.getName()));
            }
        }
    }

    private void removeFields(BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        this.removeFieldsByClass(beanDesc.getType().getRawClass(), beanProperties);
        this.removeFieldsByClass(null, beanProperties);
        this.removeFieldsByClass(Void.TYPE, beanProperties);
    }
}

