/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.filter;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.jfilter.filter.FilterBehaviour;
import com.jfilter.filter.FilterFields;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JacksonXmlRootElement(localName="config")
public class FileConfig
implements Serializable {
    private static final long serialVersionUID = -5089337585215156841L;
    @JacksonXmlProperty(localName="controller")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<Controller> controllers = new ArrayList<Controller>();

    public List<Controller> getControllers() {
        return this.controllers;
    }

    public FileConfig setControllers(List<Controller> controllers) {
        this.controllers = controllers;
        return this;
    }

    @JacksonXmlRootElement(localName="field")
    public static class Field
    implements Serializable {
        private static final long serialVersionUID = 6812574046008633856L;
        @JacksonXmlProperty(localName="name", isAttribute=true)
        private String name;

        public String getName() {
            return this.name;
        }

        public Field setName(String name) {
            this.name = name;
            return this;
        }
    }

    @JacksonXmlRootElement(localName="filter")
    public static class Filter
    implements Serializable {
        private static final long serialVersionUID = 4096598826506008282L;
        @JacksonXmlProperty(localName="class", isAttribute=true)
        private String className;
        @JacksonXmlProperty(localName="field")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Field> fields = new ArrayList<Field>();
        @JacksonXmlProperty(localName="behaviour")
        private FilterBehaviour filterBehaviour = FilterBehaviour.HIDE_FIELDS;

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public Filter setFields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public FilterBehaviour getFilterBehaviour() {
            return this.filterBehaviour;
        }

        public Filter setFilterBehaviour(FilterBehaviour filterBehaviour) {
            this.filterBehaviour = filterBehaviour;
            return this;
        }
    }

    @JacksonXmlRootElement(localName="strategy")
    public static class Strategy
    implements Serializable {
        private static final long serialVersionUID = 2166775466278797733L;
        @JacksonXmlProperty(localName="attribute-name", isAttribute=true)
        private String attributeName;
        @JacksonXmlProperty(localName="attribute-value", isAttribute=true)
        private String attributeValue;
        @JacksonXmlProperty(localName="filter")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Filter> filters = new ArrayList<Filter>();

        public String getAttributeName() {
            return this.attributeName;
        }

        public Strategy setAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public Strategy setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public Strategy setFilters(List<Filter> filters) {
            this.filters = filters;
            return this;
        }

        private Class getClassByName(String className) {
            if (className != null && !className.isEmpty()) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        public FilterFields appendStrategyFields(FilterFields filterFields) {
            this.getFilters().forEach(filter -> {
                Class clazz = this.getClassByName(filter.getClassName());
                List<String> items = filterFields.getFields(clazz);
                filter.getFields().forEach(field -> {
                    if (!items.contains(field.getName())) {
                        items.add(field.getName());
                    }
                });
                filterFields.appendToMap(clazz, items);
                filterFields.setFilterBehaviour(filter.getFilterBehaviour());
            });
            return filterFields;
        }
    }

    @JacksonXmlRootElement(localName="controller")
    public static class Controller
    implements Serializable {
        private static final long serialVersionUID = -7843796315737644281L;
        @JacksonXmlProperty(localName="class-name", isAttribute=true)
        private String className;
        @JacksonXmlProperty(localName="strategy")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Strategy> strategies = new ArrayList<Strategy>();

        public String getClassName() {
            return this.className;
        }

        public Controller setClassName(String className) {
            this.className = className;
            return this;
        }

        public List<Strategy> getStrategies() {
            return this.strategies;
        }

        public Controller setStrategies(List<Strategy> strategies) {
            this.strategies = strategies;
            return this;
        }
    }
}

