/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.filter;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.jfilter.FilterException;
import com.jfilter.components.FileWatcher;
import com.jfilter.filter.BaseFilter;
import com.jfilter.filter.FileConfig;
import com.jfilter.filter.FileFilterSetting;
import com.jfilter.filter.FilterFields;
import com.jfilter.request.RequestSession;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.springframework.core.MethodParameter;

public class FileFilter
extends BaseFilter {
    private FileConfig config;
    private Class controllerClass;
    private File file;

    public FileFilter(MethodParameter methodParameter) {
        super(methodParameter);
        this.setConfig(methodParameter);
    }

    public void setFileWatcher(FileWatcher fileWatcher) {
        if (fileWatcher != null) {
            fileWatcher.add(this.file, f -> {
                this.config = this.load(this.file);
            });
        }
    }

    private FileConfig parseFile(String fileName) {
        return this.load(FileFilter.resourceFile(fileName));
    }

    private FileConfig load(File file) {
        this.file = file;
        try {
            return file != null ? (FileConfig)new XmlMapper().readValue(file, FileConfig.class) : this.config;
        }
        catch (IOException e) {
            throw new FilterException(e);
        }
    }

    public static String getFileName(String resourceName) {
        if (!resourceName.isEmpty()) {
            ClassLoader classLoader = FileFilter.class.getClassLoader();
            URL url = classLoader.getResource(resourceName);
            return url != null ? url.getFile() : resourceName;
        }
        return "";
    }

    public static File resourceFile(String resourceName) {
        String fileName = FileFilter.getFileName(resourceName);
        File file = new File(fileName);
        return file.exists() ? file : null;
    }

    @Override
    protected void setConfig(MethodParameter methodParameter) {
        this.controllerClass = methodParameter.getContainingClass();
        FileFilterSetting fileFilterSetting = this.getRequestMethodParameter().getDeclaredAnnotation(FileFilterSetting.class);
        if (fileFilterSetting != null) {
            this.config = this.parseFile(fileFilterSetting.fileName());
        }
    }

    @Override
    public FilterFields getFields(Object object, RequestSession request) {
        FilterFields result = new FilterFields();
        if (this.config != null) {
            for (FileConfig.Controller controller : this.config.getControllers()) {
                if (!this.controllerClass.getName().equalsIgnoreCase(controller.getClassName())) continue;
                controller.getStrategies().forEach(strategy -> {
                    if (request.isSessionPropertyExists(strategy.getAttributeName(), strategy.getAttributeValue())) {
                        strategy.appendStrategyFields(result);
                    }
                });
            }
        }
        return result;
    }
}

