/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.filter;

import com.jfilter.filter.BaseFilter;
import com.jfilter.filter.FieldFilter;
import com.jfilter.filter.FieldFilterSetting;
import com.jfilter.filter.FieldFilterSettings;
import com.jfilter.filter.FileFilter;
import com.jfilter.filter.FileFilterSetting;
import com.jfilter.filter.FilterEvent;
import com.jfilter.filter.SessionStrategies;
import com.jfilter.filter.SessionStrategy;
import com.jfilter.filter.StrategyFilter;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;

public abstract class FilterFactory {
    private static final Map<Class, FilterEvent> filterList = FilterFactory.initFilterList();

    private FilterFactory() {
    }

    private static Map<Class, FilterEvent> initFilterList() {
        HashMap<Class, FilterEvent> items = new HashMap<Class, FilterEvent>();
        items.put(FieldFilterSetting.class, FieldFilter::new);
        items.put(FieldFilterSettings.class, FieldFilter::new);
        items.put(SessionStrategy.class, StrategyFilter::new);
        items.put(SessionStrategies.class, StrategyFilter::new);
        items.put(FileFilterSetting.class, FileFilter::new);
        return items;
    }

    public static Annotation getFilterAnnotation(MethodParameter methodParameter) {
        for (Annotation annotation : methodParameter.getMethod().getDeclaredAnnotations()) {
            if (!filterList.containsKey(annotation.annotationType())) continue;
            return annotation;
        }
        for (Annotation annotation : methodParameter.getContainingClass().getDeclaredAnnotations()) {
            if (!filterList.containsKey(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public static BaseFilter getFromFactory(MethodParameter methodParameter) {
        Annotation annotation = FilterFactory.getFilterAnnotation(methodParameter);
        if (annotation != null) {
            return filterList.get(annotation.annotationType()).build(methodParameter);
        }
        return null;
    }

    public static boolean isAccept(MethodParameter methodParameter) {
        for (Annotation annotation : methodParameter.getMethod().getDeclaredAnnotations()) {
            if (!filterList.containsKey(annotation.annotationType())) continue;
            return true;
        }
        for (Annotation annotation : methodParameter.getContainingClass().getDeclaredAnnotations()) {
            if (!filterList.containsKey(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }
}

