/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.filter;

import com.jfilter.filter.FilterBehaviour;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FilterFields
implements Serializable {
    private static final long serialVersionUID = -2354837314560228182L;
    public static final FilterFields EMPTY_FIELDS = new FilterFields();
    private final Map<Class, List<String>> fieldsMap = new HashMap<Class, List<String>>();
    private FilterBehaviour filterBehaviour = FilterBehaviour.HIDE_FIELDS;

    public FilterFields() {
    }

    public FilterFields(Class className, List<String> fields) {
        this();
        this.fieldsMap.put(className, fields);
    }

    public Map<Class, List<String>> getFieldsMap() {
        return this.fieldsMap;
    }

    public FilterBehaviour getFilterBehaviour() {
        return this.filterBehaviour;
    }

    public FilterFields setFilterBehaviour(FilterBehaviour filterBehaviour) {
        this.filterBehaviour = filterBehaviour;
        return this;
    }

    public List<String> getFields(Class className) {
        return this.fieldsMap.containsKey(className) ? this.fieldsMap.get(className) : new ArrayList<String>();
    }

    public void appendToMap(Class classname, List<String> fields) {
        List foundFields = this.fieldsMap.computeIfAbsent(classname, k -> new ArrayList());
        fields.forEach(v -> {
            if (!foundFields.contains(v)) {
                foundFields.add(v);
            }
        });
    }

    public static FilterFields getFieldsBy(Class classname, List<String> fields) {
        return new FilterFields(classname, fields);
    }

    public static FilterFields getFieldsBy(List<String> fields) {
        return FilterFields.getFieldsBy(Void.TYPE, fields);
    }

    public static FilterFields getFieldsBy(Class classname, String[] fields) {
        return FilterFields.getFieldsBy(classname, Arrays.asList(fields));
    }

    public static FilterFields getFieldsBy(String[] fields) {
        return FilterFields.getFieldsBy(Void.TYPE, Arrays.asList(fields));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FilterFields)) {
            return false;
        }
        FilterFields that = (FilterFields)object;
        return Objects.equals(this.fieldsMap, that.fieldsMap) && this.filterBehaviour == that.filterBehaviour;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldsMap, this.filterBehaviour});
    }
}

