/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.filter;

import com.jfilter.filter.BaseFilter;
import com.jfilter.filter.FieldFilterSetting;
import com.jfilter.filter.FilterFields;
import com.jfilter.filter.SessionStrategy;
import com.jfilter.request.RequestSession;
import java.util.Arrays;
import org.springframework.core.MethodParameter;

public class StrategyFilter
extends BaseFilter {
    private SessionStrategy[] config;

    public StrategyFilter(MethodParameter methodParameter) {
        super(methodParameter);
        this.setConfig(methodParameter);
    }

    @Override
    protected void setConfig(MethodParameter methodParameter) {
        this.config = this.getRequestMethodParameter().getStrategyAnnotations(methodParameter);
    }

    @Override
    public FilterFields getFields(Object object, RequestSession request) {
        FilterFields result = new FilterFields();
        for (SessionStrategy strategy : this.config) {
            if (!request.isSessionPropertyExists(strategy.attributeName(), strategy.attributeValue())) continue;
            for (FieldFilterSetting setting : strategy.ignoreFields()) {
                result.appendToMap(setting.className(), Arrays.asList(setting.fields()));
                result.setFilterBehaviour(setting.behaviour());
            }
        }
        return result;
    }
}

