/*
 * Decompiled with CFR 0.152.
 */
package com.jfilter.request;

import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;

public class RequestSession {
    private final HttpSession session;
    private final HttpServletRequest request;

    public RequestSession(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this.request = request;
        this.session = request.getSession();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    private boolean hasSessionProperty(String propertyName) {
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (!attribute.equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public Object getSessionProperty(String attributeName) {
        return attributeName != null ? this.session.getAttribute(attributeName) : null;
    }

    public boolean isSessionPropertyExists(String attributeName, String attributeValue) {
        if (attributeName == null && attributeValue == null) {
            return false;
        }
        if (StringUtils.isEmpty((Object)attributeName) && StringUtils.isEmpty((Object)attributeValue)) {
            return true;
        }
        if (this.hasSessionProperty(attributeName)) {
            Object sessionObject = this.getSessionProperty(attributeName);
            return Objects.equals(sessionObject, attributeValue);
        }
        return false;
    }
}

