/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.contract;

import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;

public class Conditions {
    public static void ensureTrue(boolean condition) {
        Conditions.ensureTrue(condition, "Expected condition to be true but was false");
    }

    public static void ensureTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static <T> T notNull(T notNull, String message) {
        if (notNull == null) {
            throw new IllegalStateException(message);
        }
        return notNull;
    }

    public static <T> T notNull(T notNull) {
        return Conditions.notNull(notNull, "Expected argument to not be null");
    }

    public static void ensureNull(Object obj) {
        Conditions.ensureNull(obj, "Expected argument to be null");
    }

    public static void ensureNull(Object obj, String message) {
        if (obj != null) {
            throw new IllegalStateException(message);
        }
    }

    public static void ensureFalse(boolean condition) {
        if (condition) {
            throw new IllegalStateException("Expected condition to be false but was true");
        }
    }

    public static <T> T notEmpty(T obj) {
        if (obj instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)obj))) {
            throw new IllegalStateException("Expected char sequence to not be empty");
        }
        if (obj instanceof Iterable && Iterables.isEmpty((Iterable)((Iterable)obj))) {
            throw new IllegalStateException("Expected iterable to not be empty");
        }
        return Conditions.notNull(obj);
    }

    public static void ensureAllNotNull(Object ... objects) {
        for (Object object : objects) {
            Conditions.notNull(object);
        }
    }

    public static void ensureAllTrue(boolean ... conditions) {
        for (boolean condition : conditions) {
            Conditions.ensureTrue(condition);
        }
    }
}

