/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.mail;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import nz.co.testamation.common.mail.Email;
import nz.co.testamation.common.mail.EmailClient;
import nz.co.testamation.common.mail.MimeMessageFactory;
import nz.co.testamation.common.mail.SendEmailJobFactory;
import nz.co.testamation.common.mail.SendEmailJobFactoryImpl;

public class AsyncEmailClient
implements EmailClient {
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final MimeMessageFactory mimeMessageFactory;
    private final SendEmailJobFactory sendEmailJobFactory;

    public AsyncEmailClient(MimeMessageFactory mimeMessageFactory) {
        this(new ScheduledThreadPoolExecutor(1), mimeMessageFactory, new SendEmailJobFactoryImpl());
    }

    public AsyncEmailClient(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, MimeMessageFactory mimeMessageFactory, SendEmailJobFactory sendEmailJobFactory) {
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.mimeMessageFactory = mimeMessageFactory;
        this.sendEmailJobFactory = sendEmailJobFactory;
    }

    @Override
    public void send(Email email) {
        this.scheduledThreadPoolExecutor.execute(this.sendEmailJobFactory.create(this.mimeMessageFactory.create(email)));
    }
}

