/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.mail;

import nz.co.testamation.common.util.StringConcat;

public class EmailAddresses {
    private static final String ADDRESS_SEPERATOR = ", ";
    private String from;
    private String replyTo;
    private String toAddresses;
    private String ccAddresses;
    private String bccAddresses;

    public EmailAddresses(String from) {
        this(from, null, null, null, null);
    }

    public EmailAddresses(String from, String toAddresses) {
        this(from, toAddresses, null, null, null);
    }

    public EmailAddresses(String from, String toAddresses, String ccAddresses, String bccAddresses, String replyTo) {
        this.from = from;
        this.toAddresses = toAddresses;
        this.ccAddresses = ccAddresses;
        this.bccAddresses = bccAddresses;
        this.replyTo = replyTo;
    }

    public String getFrom() {
        return this.from;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getToAddresses() {
        return this.toAddresses;
    }

    public String getCcAddresses() {
        return this.ccAddresses;
    }

    public String getBccAddresses() {
        return this.bccAddresses;
    }

    public EmailAddresses to(String additionalToAddresses) {
        return this.to(additionalToAddresses, null, null);
    }

    public EmailAddresses to(String additionalToAddresses, String additionalCcAddresses) {
        return this.to(additionalToAddresses, additionalCcAddresses, null);
    }

    public EmailAddresses to(String additionalToAddresses, String additionalCcAddresses, String additionalBccAddresses) {
        return new EmailAddresses(this.getFrom(), this.concatenateAddresses(this.getToAddresses(), additionalToAddresses), this.concatenateAddresses(this.getCcAddresses(), additionalCcAddresses), this.concatenateAddresses(this.getBccAddresses(), additionalBccAddresses), this.getReplyTo());
    }

    private String concatenateAddresses(String originalAddresses, String additionalToAddresses) {
        String s = new StringConcat(ADDRESS_SEPERATOR).append(originalAddresses).append(additionalToAddresses).toNullString();
        return s;
    }
}

