/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.mail;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import nz.co.testamation.common.mail.Email;
import nz.co.testamation.common.mail.EmailClient;
import nz.co.testamation.common.mail.MimeMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailClientImpl
implements EmailClient {
    private static final Logger logger = LoggerFactory.getLogger(EmailClientImpl.class);
    private final MimeMessageFactory mimeMessageFactory;

    public EmailClientImpl(MimeMessageFactory mimeMessageFactory) {
        this.mimeMessageFactory = mimeMessageFactory;
    }

    @Override
    public void send(Email email) {
        try {
            Transport.send((Message)this.mimeMessageFactory.create(email));
        }
        catch (MessagingException e) {
            logger.error("Failed to send email", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

