/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.mail;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nz.co.testamation.common.mail.Email;
import nz.co.testamation.common.mail.EmailAddresses;
import nz.co.testamation.common.mail.MailSessionFactory;
import nz.co.testamation.common.mail.MimeMessageFactory;
import nz.co.testamation.common.mail.MultipartMessageFactory;
import org.apache.commons.lang3.StringUtils;

public class MimeMessageFactoryImpl
implements MimeMessageFactory {
    private final Session session;
    private MultipartMessageFactory multipartMessageFactory;

    public MimeMessageFactoryImpl(MailSessionFactory mailSessionFactory, MultipartMessageFactory multipartMessageFactory) {
        this.multipartMessageFactory = multipartMessageFactory;
        this.session = mailSessionFactory.create();
    }

    @Override
    public Message create(Email email) {
        try {
            EmailAddresses emailAddresses = email.getEmailAddresses();
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setSubject(email.getSubject());
            mimeMessage.setFrom((Address)new InternetAddress(emailAddresses.getFrom()));
            if (StringUtils.isNotBlank((CharSequence)emailAddresses.getReplyTo())) {
                mimeMessage.setReplyTo((Address[])InternetAddress.parse((String)emailAddresses.getReplyTo()));
            }
            this.addRecipients(mimeMessage, Message.RecipientType.TO, emailAddresses.getToAddresses());
            this.addRecipients(mimeMessage, Message.RecipientType.CC, emailAddresses.getCcAddresses());
            this.addRecipients(mimeMessage, Message.RecipientType.BCC, emailAddresses.getBccAddresses());
            mimeMessage.setContent(this.multipartMessageFactory.create(email));
            mimeMessage.setSentDate(new Date());
            return mimeMessage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addRecipients(MimeMessage mimeMessage, Message.RecipientType type, String emailAddresses) throws MessagingException {
        if (StringUtils.isNotBlank((CharSequence)emailAddresses)) {
            mimeMessage.addRecipients(type, emailAddresses);
        }
    }
}

