/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.mail;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import nz.co.testamation.common.mail.AttachmentBodyPartFactory;
import nz.co.testamation.common.mail.AttachmentBodyPartFactoryImpl;
import nz.co.testamation.common.mail.Email;
import nz.co.testamation.common.mail.EmailAttachment;
import nz.co.testamation.common.mail.MultipartMessageFactory;
import nz.co.testamation.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class MultipartMessageFactoryImpl
implements MultipartMessageFactory {
    private final AttachmentBodyPartFactory attachmentBodyPartFactory;

    public MultipartMessageFactoryImpl() {
        this(new AttachmentBodyPartFactoryImpl());
    }

    public MultipartMessageFactoryImpl(AttachmentBodyPartFactory attachmentBodyPartFactory) {
        this.attachmentBodyPartFactory = attachmentBodyPartFactory;
    }

    @Override
    public Multipart create(Email email) throws MessagingException {
        MimeMultipart multipart = StringUtils.isNotBlank((CharSequence)email.getHtmlBody()) ? new MimeMultipart("alternative") : new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(StringUtil.toNotNullString(email.getTextBody()));
        multipart.addBodyPart((BodyPart)textPart);
        if (StringUtils.isNotBlank((CharSequence)email.getHtmlBody())) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)email.getHtmlBody(), "text/html");
            multipart.addBodyPart((BodyPart)htmlPart);
        }
        if (email.getAttachments() != null) {
            for (EmailAttachment attachment : email.getAttachments()) {
                multipart.addBodyPart(this.attachmentBodyPartFactory.create(attachment));
            }
        }
        return multipart;
    }
}

