/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DateUtil {
    public static <T extends Comparable> T getMax(Collection<T> collection) {
        Optional<T> max = collection.stream().max((o1, o2) -> o1.compareTo(o2));
        return (T)(max.isPresent() ? (Comparable)max.get() : null);
    }

    public static long daysBetween(LocalDate start, LocalDate end, List<DayOfWeek> ignore) {
        return Stream.iterate(start, d -> d.plusDays(1L)).limit(start.until(end, ChronoUnit.DAYS)).filter(d -> !ignore.contains(d.getDayOfWeek())).count();
    }

    public static long weekDaysBetween(LocalDate start, LocalDate end) {
        return DateUtil.daysBetween(start, end, (List<DayOfWeek>)ImmutableList.of((Object)DayOfWeek.SATURDAY, (Object)DayOfWeek.SUNDAY));
    }

    public static LocalDate getDateInThePast(LocalDate endDate, int requiredNumberWorkingDays, List<LocalDate> holidays) {
        LocalDate start = endDate.minusDays(requiredNumberWorkingDays);
        long workingDaysBetween = DateUtil.workingDaysBetween(start, endDate, holidays);
        while (workingDaysBetween < (long)requiredNumberWorkingDays) {
            start = start.minusDays(1L);
            workingDaysBetween = DateUtil.workingDaysBetween(start, endDate, holidays);
        }
        return start;
    }

    public static LocalDate getDateInTheFuture(LocalDate start, int requiredNumberWorkingDays, List<LocalDate> holidays) {
        LocalDate end = start.plusDays(requiredNumberWorkingDays);
        long workingDaysBetween = DateUtil.workingDaysBetween(start, end, holidays);
        while (workingDaysBetween < (long)requiredNumberWorkingDays) {
            end = end.plusDays(1L);
            workingDaysBetween = DateUtil.workingDaysBetween(start, end, holidays);
        }
        return end;
    }

    public static long workingDaysBetween(LocalDate start, LocalDate endDate, List<LocalDate> holidays) {
        if (endDate.isBefore(start)) {
            throw new IllegalStateException(String.format("Expected endDate(%s) to be the same or after startDate(%s)", start, endDate));
        }
        return Stream.iterate(start, d -> d.plusDays(1L)).limit(start.until(endDate, ChronoUnit.DAYS)).filter(d -> !ImmutableList.of((Object)DayOfWeek.SATURDAY, (Object)DayOfWeek.SUNDAY).contains((Object)d.getDayOfWeek())).filter(d -> !holidays.contains(d)).count();
    }

    public static String getDayOfMonthSuffix(LocalDate date) {
        int n = date.getDayOfMonth();
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static String getDayOfMonthFormattedDate(LocalDate date) {
        return String.format("this %s day of %s %s", date.getDayOfMonth() + DateUtil.getDayOfMonthSuffix(date), CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, date.getMonth().toString()), date.getYear());
    }
}

