/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.lang3.StringUtils;

public class PrefixMapNamespaceContext
implements NamespaceContext {
    final Map<String, String> prefixNamespaceMap;

    public PrefixMapNamespaceContext(Map<String, String> prefixNamespaceMap) {
        this.prefixNamespaceMap = prefixNamespaceMap;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        switch (prefix) {
            case "xml": {
                return "http://www.w3.org/XML/1998/namespace";
            }
            case "xmlns": {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        return StringUtils.defaultString((String)this.prefixNamespaceMap.get(prefix), (String)"");
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator<String> prefixes = this.getPrefixes(namespaceURI);
        if (prefixes.hasNext()) {
            return prefixes.next();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.prefixNamespaceMap.entrySet().stream().filter(entry -> namespaceURI.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).iterator();
    }
}

