/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.common.util;

import com.google.common.collect.ImmutableMap;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nz.co.testamation.common.util.PrefixMapNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlUtil {
    public static Document toDocument(String str) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Document document = new DocumentBuilderFactoryImpl().newDocumentBuilder().newDocument();
            transformerFactory.newTransformer().transform(new StreamSource(new StringReader(str)), new DOMResult(document));
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static NamespaceContext toNameSpaceContext(Map<String, String> namespace) {
        return new PrefixMapNamespaceContext(namespace);
    }

    public static XPathExpression compileXPath(String xPathExpression, NamespaceContext namespaceContext) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (namespaceContext != null) {
                xPath.setNamespaceContext(namespaceContext);
            }
            return xPath.compile(xPathExpression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath : " + xPathExpression, e);
        }
    }

    public static XPathExpression compileXPath(String xPathExpression, Map<String, String> namespaceContext) {
        return XmlUtil.compileXPath(xPathExpression, XmlUtil.toNameSpaceContext(namespaceContext));
    }

    public static String toString(Node node) {
        try {
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toString(DOMResult domResult) {
        return XmlUtil.toString(((Document)domResult.getNode()).getDocumentElement());
    }

    public static String selectString(Node node, String xPathExpression, ImmutableMap<String, String> namespaces) {
        try {
            return XmlUtil.compileXPath(xPathExpression, namespaces).evaluate(node);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static String selectString(Node node, String xPathExpression) {
        return XmlUtil.selectString(node, xPathExpression, (ImmutableMap<String, String>)ImmutableMap.of());
    }
}

