/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.testcommon.template;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import nz.co.testamation.testcommon.template.FieldUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class MockitoTestTemplate {
    private List mocks = Lists.newArrayList();
    private InOrder inOrder;
    private Throwable whenException = null;

    public final void run() throws Exception {
        try {
            this.given();
        }
        catch (Throwable e) {
            throw new Error("Unable to prepare test", e);
        }
        Throwable thenException = null;
        try {
            this.when();
        }
        catch (Throwable e) {
            this.whenException = e;
        }
        try {
            this.then();
        }
        catch (Throwable e) {
            thenException = e;
        }
        Mockito.validateMockitoUsage();
        MockitoTestTemplate.handleExceptions(this.whenException, thenException);
    }

    public static void handleExceptions(Throwable whenException, Throwable thenException) throws Exception {
        if (whenException != null && thenException != null) {
            whenException.printStackTrace();
            System.err.println();
            System.err.println("when() threw exception above. then() threw exception below.");
            MockitoTestTemplate.throwException(thenException);
        } else if (whenException != null) {
            MockitoTestTemplate.throwException(whenException);
        } else if (thenException != null) {
            MockitoTestTemplate.throwException(thenException);
        }
    }

    public static void throwException(Throwable e) throws Exception {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        throw new UnsupportedOperationException("Unhandled subclass of Throwable", e);
    }

    protected void given() throws Exception {
    }

    protected void when() throws Exception {
    }

    protected void then() throws Exception {
    }

    protected Exception expectedException() {
        if (this.whenException == null) {
            throw new Error("There was no exception in when()");
        }
        return (Exception)this.whenException;
    }

    public <T> OngoingStubbing<T> given(T value) {
        return Mockito.when(value);
    }

    public Stubber doAnswer(Answer answer) {
        return Mockito.doAnswer((Answer)answer);
    }

    public <T> T mock(Class<T> toMock) {
        Object mock = Mockito.mock(toMock);
        this.mocks.add(mock);
        this.inOrder = Mockito.inOrder((Object[])Iterables.toArray((Iterable)this.mocks, Object.class));
        return (T)mock;
    }

    protected <E> E expectedException(Class<E> exceptionClass) {
        return exceptionClass.cast(this.whenException);
    }

    public <T> T verifyInOrder(T mock) {
        return (T)this.inOrder.verify(mock);
    }

    public <T> T verifyNever(T mock) {
        return (T)Mockito.verify(mock, (VerificationMode)Mockito.never());
    }

    public <T> T verify(T mock, VerificationMode mode) {
        return (T)Mockito.verify(mock, (VerificationMode)mode);
    }

    public <T> T verify(T mock) {
        return (T)Mockito.verify(mock);
    }

    public void verifyZeroInteractions(Object ... mocks) {
        Mockito.verifyZeroInteractions((Object[])mocks);
    }

    public void verifyNoMoreInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    public Stubber doThrow(Throwable toBeThrown) {
        return Mockito.doThrow((Throwable)toBeThrown);
    }

    public <T> void assertThat(T actual, Matcher<? extends T> matcher) {
        MatcherAssert.assertThat(actual, matcher);
    }

    public void assertField(Object object, String fieldName, Matcher matcher) {
        MatcherAssert.assertThat((Object)FieldUtil.getFieldValue(object, fieldName), (Matcher)matcher);
    }

    public static <T> Matcher<T> equalTo(T operand) {
        return Matchers.equalTo(operand);
    }

    public void setField(Object obj, String fieldName, Object value) {
        FieldUtil.setField(obj, fieldName, value);
    }

    public <T> T getField(Object obj, String fieldName, Class<T> clazz) {
        return FieldUtil.getFieldValue(obj, fieldName, clazz);
    }
}

