/*
 * Decompiled with CFR 0.152.
 */
package nz.co.testamation.testcommon.fixture;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;

public class SomeFixture {
    public static String someString(int length) {
        return RandomStringUtils.randomAlphabetic((int)length);
    }

    public static String someString() {
        return RandomStringUtils.randomAlphabetic((int)7);
    }

    public static int someInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static long someLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static int someIntLessThan(int maxExclusive) {
        return ThreadLocalRandom.current().nextInt(maxExclusive);
    }

    public static int someYear() {
        return 2000 + SomeFixture.someIntLessThan(11);
    }

    public static Duration someDuration() {
        return Duration.ofSeconds(SomeFixture.someLong());
    }

    public static String someEmail() {
        return String.format("%s@%s.com", RandomStringUtils.randomAlphabetic((int)5), RandomStringUtils.randomAlphabetic((int)5)).toLowerCase();
    }

    public static LocalDate someLocalDate() {
        return LocalDate.of(SomeFixture.someYear(), SomeFixture.someIntLessThan(12) + 1, SomeFixture.someIntLessThan(28) + 1);
    }

    public static LocalDateTime someDateTime() {
        return LocalDateTime.of(SomeFixture.someYear(), SomeFixture.someIntLessThan(12) + 1, SomeFixture.someIntLessThan(28) + 1, (int)SomeFixture.someIntBetween(4, 24), SomeFixture.someIntLessThan(60), SomeFixture.someIntLessThan(60));
    }

    public static Boolean someBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static <E extends Enum> E someEnum(Class<E> enumClazz) {
        return (E)((Enum)SomeFixture.someValue(enumClazz.getEnumConstants()));
    }

    public static <E extends Enum> E someEnum(Class<E> enumClazz, Predicate<E> predicate) {
        E result;
        while (!predicate.apply(result = SomeFixture.someEnum(enumClazz))) {
        }
        return result;
    }

    public static <T extends Enum> T someEnumOtherThan(Class<T> enumClazz, T ... excluded) {
        return (T)((Enum)SomeFixture.someValue(Sets.difference((Set)ImmutableSet.copyOf((Object[])enumClazz.getEnumConstants()), (Set)ImmutableSet.copyOf((Object[])excluded))));
    }

    private static int someInt(int length) {
        return new Integer(RandomStringUtils.randomNumeric((int)length));
    }

    public static Integer someIntBetween(int minInclusive, int maxExclusive) {
        return ThreadLocalRandom.current().nextInt(minInclusive, maxExclusive);
    }

    public static String someEmail(String prefix) {
        return prefix + "_" + SomeFixture.someEmail();
    }

    public static BigDecimal someBigDecimal() {
        return new BigDecimal(SomeFixture.somePositiveInt());
    }

    public static BigDecimal someBigDecimalPercentage() {
        return new BigDecimal(SomeFixture.someDouble());
    }

    public static double someDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static byte[] someBytes() {
        return SomeFixture.someString().getBytes();
    }

    public static int somePositiveInt() {
        return Math.abs(SomeFixture.someInt());
    }

    public static <T> T someValue(T ... values) {
        return values[SomeFixture.someIntLessThan(values.length)];
    }

    public static <T> T someValue(Collection<T> values) {
        return (T)Iterables.get(values, (int)SomeFixture.someIntLessThan(values.size()));
    }

    public static String someString(String ... choises) {
        return choises[SomeFixture.someIntBetween(0, choises.length)];
    }

    public static String someString(Iterable<String> choices) {
        return SomeFixture.someString((String[])Iterables.toArray(choices, String.class));
    }

    public static BigInteger someBigInteger() {
        return new BigInteger(String.valueOf(SomeFixture.somePositiveInt()));
    }

    public static <T> T someThing(T ... things) {
        return things[SomeFixture.someIntBetween(0, things.length)];
    }
}

