/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.arquillian.microbenchmark.internal.client;

import java.io.File;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.ziplock.JarLocation;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.filter.IncludeRegExpPaths;
import org.jfree.JCommon;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroBenchmarkApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (LibraryContainer.class.isInstance(applicationArchive) && !JavaArchive.class.isInstance(applicationArchive)) {
            LibraryContainer container = (LibraryContainer)LibraryContainer.class.cast(applicationArchive);
            if (applicationArchive.getContent((Filter)new IncludeRegExpPaths("/WEB-INF/lib/commons-math3.*.jar")).size() == 0) {
                container.addAsLibraries(new File[]{JarLocation.jarLocation(DescriptiveStatistics.class)});
            }
            if (applicationArchive.getContent((Filter)new IncludeRegExpPaths("/WEB-INF/lib/jfreechart.*.jar")).size() == 0) {
                container.addAsLibraries(new File[]{JarLocation.jarLocation(JCommon.class), JarLocation.jarLocation(JFreeChart.class)});
            }
        }
    }
}

