/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.arquillian.microbenchmark.internal.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroBenchmarkConfiguration {
    public static final String CONFIGURATION_PATH = "microbenchmark.properties";
    private boolean activated = true;
    private boolean detailed = true;
    private int width = 800;
    private int height = 600;
    private boolean saveDiagram = false;
    private String diagramFolder = "target/micro-benchmark";

    public String asString() {
        StringBuilder builder = new StringBuilder();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                builder.append(field.getName()).append(" = ").append(MicroBenchmarkConfiguration.toString(field.get(this))).append("\n");
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    public void initFromInputStream(InputStream inputStream) {
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.readFromMap(props);
    }

    public void readFromMap(Map<?, ?> extensionProperties) {
        if (extensionProperties == null) {
            return;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            String name = field.getName();
            if (!extensionProperties.containsKey(name)) continue;
            try {
                field.set(this, this.fromString(field.getType(), extensionProperties.get(name)));
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public String getDiagramFolder() {
        return this.diagramFolder;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSaveDiagram() {
        return this.saveDiagram;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSaveDiagram(boolean saveDiagram) {
        this.saveDiagram = saveDiagram;
    }

    public void setDiagramFolder(String diagramFolder) {
        this.diagramFolder = diagramFolder;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    private static String toString(Object o) {
        return "" + o;
    }

    private Object fromString(Class<?> type, Object property) {
        if (!String.class.isInstance(property)) {
            return property;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.parseBoolean((String)String.class.cast(property));
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.parseInt((String)String.class.cast(property));
        }
        return property;
    }
}

