/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.arquillian.microbenchmark.internal.shared;

import com.github.rmannibucau.arquillian.microbenchmark.api.AssertionException;
import com.github.rmannibucau.arquillian.microbenchmark.api.MicroBenchmarkAssertion;
import com.github.rmannibucau.arquillian.microbenchmark.internal.configuration.MicroBenchmarkConfiguration;
import com.github.rmannibucau.arquillian.microbenchmark.internal.shared.Annotations;
import com.github.rmannibucau.arquillian.microbenchmark.internal.shared.MicroBenchmarkRunConfiguration;
import com.github.rmannibucau.arquillian.microbenchmark.internal.shared.MultipleExceptions;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jboss.arquillian.container.test.impl.execution.LocalTestExecuter;
import org.jboss.arquillian.container.test.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroBenchmarkObserver
extends LocalTestExecuter {
    private static final Logger LOGGER = Logger.getLogger(MicroBenchmarkObserver.class.getName());
    private static final long DEFAULT_TIMEOUT_MS = 600000L;
    @Inject
    private Instance<MicroBenchmarkConfiguration> configuration;
    @Inject
    @TestScoped
    private InstanceProducer<TestResult> testResult;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void execute(@Observes LocalExecutionEvent event) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bench(@Observes(precedence=-1) EventContext<LocalExecutionEvent> eventContext) throws Throwable {
        TestMethodExecutor executor = ((LocalExecutionEvent)eventContext.getEvent()).getExecutor();
        MicroBenchmarkRunConfiguration run = MicroBenchmarkRunConfiguration.readConfiguration(executor.getMethod(), ((MicroBenchmarkConfiguration)this.configuration.get()).isDetailed());
        if (run == null || !((MicroBenchmarkConfiguration)this.configuration.get()).isActivated()) {
            eventContext.proceed();
            return;
        }
        TestResult result = new TestResult();
        try {
            Object[] parameters = this.findParameters(executor, ((ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class));
            this.warmup(executor, run, parameters);
            this.bench(executor, parameters, run);
            result.setStatus(TestResult.Status.PASSED);
        }
        catch (Throwable e) {
            result.setStatus(TestResult.Status.FAILED);
            result.setThrowable(e);
            MicroBenchmarkObserver.reportException(e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
        }
        this.testResult.set((Object)result);
    }

    private void warmup(TestMethodExecutor executor, MicroBenchmarkRunConfiguration run, Object[] parameters) throws Throwable {
        ExecutorService es;
        if (run.getWarmupDuration() > 0) {
            es = Executors.newFixedThreadPool(run.getWarmupThreads());
            LOGGER.info("Running warmup for " + run.getWarmupDuration() + "ms");
            ArrayList<TimedInvocation> timedTasks = new ArrayList<TimedInvocation>();
            long start = System.nanoTime();
            long end = start + TimeUnit.MILLISECONDS.toNanos(run.getDuration());
            for (int i = 0; i < run.getWarmupThreads(); ++i) {
                timedTasks.add(new TimedInvocation(executor, parameters, end, run.isDetailed()));
            }
            es.invokeAll(timedTasks);
            es.shutdown();
            MicroBenchmarkObserver.waitExecutor(es, MicroBenchmarkObserver.extractTimeout(executor.getMethod()), TimeUnit.MILLISECONDS);
        }
        if (run.getWarmupIterations() > 0) {
            es = Executors.newFixedThreadPool(run.getWarmupThreads());
            LOGGER.info("Running warmup for " + run.getWarmupIterations() + " iterations");
            for (int i = 0; i < run.getWarmupIterations(); ++i) {
                es.submit(new Invocation(executor, parameters));
            }
            es.shutdown();
            MicroBenchmarkObserver.waitExecutor(es, MicroBenchmarkObserver.extractTimeout(executor.getMethod()), TimeUnit.MILLISECONDS);
        }
    }

    private void bench(TestMethodExecutor executor, Object[] params, MicroBenchmarkRunConfiguration run) throws Throwable {
        DescriptiveStatistics stats;
        ArrayList<Long> durations;
        long start;
        String benchTitle;
        int threads = run.getThreads();
        long timeout = MicroBenchmarkObserver.extractTimeout(executor.getMethod());
        if (run.getDuration() > 0) {
            ExecutorService es = Executors.newFixedThreadPool(threads);
            benchTitle = "Running micro-bench for " + run.getDuration() + " ms";
            LOGGER.info(benchTitle);
            ArrayList<TimedInvocation> timedTasks = new ArrayList<TimedInvocation>();
            start = System.nanoTime();
            long end = start + TimeUnit.MILLISECONDS.toNanos(run.getDuration());
            for (int i = 0; i < threads; ++i) {
                timedTasks.add(new TimedInvocation(executor, params, end, run.isDetailed()));
            }
            long realStart = System.nanoTime();
            es.invokeAll(timedTasks);
            MicroBenchmarkObserver.waitExecutor(es, timeout, TimeUnit.MILLISECONDS);
            long realEnd = System.nanoTime();
            List<Throwable> results = this.extractErrors(timedTasks);
            durations = new ArrayList();
            for (TimedInvocation invocation : timedTasks) {
                durations.addAll(invocation.getDurations());
            }
            long duration = TimeUnit.NANOSECONDS.toMillis(realEnd - realStart);
            MicroBenchmarkObserver.validExecution(results, run.isIgnoreExceptions());
            stats = this.report(benchTitle, executor, run, durations, duration);
            MicroBenchmarkObserver.asserts(executor, stats, duration);
        }
        if (run.getIterations() > 0) {
            Collection<Invocation> tasks = MicroBenchmarkObserver.createTaks(executor, params, run);
            benchTitle = "Running micro-bench for " + run.getIterations() + " iterations";
            LOGGER.info(benchTitle);
            ExecutorService es = Executors.newFixedThreadPool(threads);
            start = System.nanoTime();
            List results = es.invokeAll(tasks);
            MicroBenchmarkObserver.waitExecutor(es, timeout, TimeUnit.MILLISECONDS);
            long end = System.nanoTime();
            durations = new ArrayList<Long>();
            if (run.isDetailed()) {
                for (Invocation i : tasks) {
                    durations.add(((DetailedInvocation)DetailedInvocation.class.cast(i)).getDuration());
                }
            }
            long duration = TimeUnit.NANOSECONDS.toMillis(end - start);
            MicroBenchmarkObserver.validExecution(MicroBenchmarkObserver.unwrapFutures(results), run.isIgnoreExceptions());
            stats = this.report(benchTitle, executor, run, durations, duration);
            MicroBenchmarkObserver.asserts(executor, stats, duration);
        }
    }

    private List<Throwable> extractErrors(Collection<TimedInvocation> timedTasks) {
        ArrayList<Throwable> results = new ArrayList<Throwable>();
        for (TimedInvocation invocation : timedTasks) {
            results.addAll(invocation.getResults());
        }
        return results;
    }

    private static void asserts(TestMethodExecutor executor, DescriptiveStatistics stats, long total) {
        MicroBenchmarkAssertion assertions = Annotations.findAnnotation(executor.getMethod(), MicroBenchmarkAssertion.class);
        if (assertions == null) {
            return;
        }
        MicroBenchmarkObserver.checkAssertion("max", assertions.max(), stats.getMax());
        MicroBenchmarkObserver.checkAssertion("average", assertions.average(), stats.getMean());
        MicroBenchmarkObserver.checkAssertion("total", assertions.total(), total);
    }

    private static void checkAssertion(String msg, long expectedMax, double actualMax) {
        if (expectedMax >= 0L && actualMax > (double)expectedMax) {
            throw new AssertionException("Expected " + msg + " < " + expectedMax + " and got " + actualMax);
        }
    }

    private DescriptiveStatistics report(String title, TestMethodExecutor executor, MicroBenchmarkRunConfiguration run, Collection<Long> durations, long duration) {
        String info;
        DescriptiveStatistics stats;
        LOGGER.info("Micro-bench on " + executor.getMethod().getDeclaringClass().getSimpleName() + "#" + executor.getMethod().getName() + " lasted " + duration + "ms with " + run.getThreads() + " threads.");
        if (run.isDetailed()) {
            stats = MicroBenchmarkObserver.createStatistics(durations);
            info = stats.toString().replace("\n", ", ").substring("DescriptiveStatistics:, ".length());
            LOGGER.info("Aggregates: " + info);
        } else {
            stats = MicroBenchmarkObserver.createStatistics(Arrays.asList(duration));
            info = "data aggregated";
        }
        if (((MicroBenchmarkConfiguration)this.configuration.get()).isSaveDiagram()) {
            MicroBenchmarkObserver.saveDiagram(executor, stats.getValues(), (MicroBenchmarkConfiguration)this.configuration.get(), title, info);
        }
        return stats;
    }

    private static DescriptiveStatistics createStatistics(Collection<Long> durations) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (Long it : durations) {
            stats.addValue((double)it.longValue());
        }
        return stats;
    }

    private static void saveDiagram(TestMethodExecutor executor, double[] durations, MicroBenchmarkConfiguration config, String title, String info) {
        HashMap<Long, Integer> xyValues = new HashMap<Long, Integer>();
        for (double it : durations) {
            long key = Double.valueOf(it).longValue();
            Integer number = (Integer)xyValues.get(key);
            if (number == null) {
                xyValues.put(key, 1);
                continue;
            }
            xyValues.put(key, 1 + number);
        }
        XYSeries xy = new XYSeries((Comparable)Integer.valueOf(1), true);
        for (Map.Entry entry : xyValues.entrySet()) {
            xy.add((Number)entry.getKey(), (Number)entry.getValue());
        }
        JFreeChart chart = ChartFactory.createHistogram((String)(title + "(" + info + ")"), (String)"Duration (ms)", (String)"Number", (IntervalXYDataset)new XYSeriesCollection(xy), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        chart.getXYPlot().getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        try {
            File file = new File(config.getDiagramFolder(), executor.getMethod().getName() + ".png");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                LOGGER.warning("Can't create " + file.getParent());
            }
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)config.getWidth(), (int)config.getHeight());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static Collection<Invocation> createTaks(TestMethodExecutor executor, Object[] params, MicroBenchmarkRunConfiguration run) {
        ArrayList<Invocation> tasks = new ArrayList<Invocation>(run.getIterations());
        for (int i = 0; i < run.getIterations(); ++i) {
            tasks.add(MicroBenchmarkObserver.newInvocation(executor, params, run.isDetailed()));
        }
        return tasks;
    }

    private static Invocation newInvocation(TestMethodExecutor executor, Object[] params, boolean detailed) {
        Invocation invocation = !detailed ? new Invocation(executor, params) : new DetailedInvocation(executor, params);
        return invocation;
    }

    private Object[] findParameters(TestMethodExecutor executor, Collection<TestEnricher> all) {
        try {
            Method m = LocalTestExecuter.class.getDeclaredMethod("enrichArguments", Method.class, Collection.class);
            m.setAccessible(true);
            return (Object[])Object[].class.cast(m.invoke((Object)this, executor.getMethod(), all));
        }
        catch (Exception e) {
            throw new RuntimeException("Arquillian internals have probably changed, check your version", e);
        }
    }

    private static void reportException(Throwable e) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.arquillian.junit.State");
            clazz.getDeclaredMethod("caughtTestException", Throwable.class).invoke(null, e);
        }
        catch (Exception ignored) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static void validExecution(Collection<Throwable> throwables, boolean ignoreExceptions) throws Exception {
        if (!throwables.isEmpty() && !ignoreExceptions) {
            throw new MultipleExceptions(throwables);
        }
    }

    private static void waitExecutor(ExecutorService es, long duration, TimeUnit unit) throws InterruptedException {
        es.shutdown();
        es.awaitTermination(duration, unit);
    }

    private static long extractTimeout(Method method) {
        for (Annotation a : method.getDeclaredAnnotations()) {
            if (!a.annotationType().getName().equals("org.junit.Test")) continue;
            try {
                Long timeout = (Long)a.annotationType().getMethod("timeout", new Class[0]).invoke((Object)a, new Object[0]);
                if (timeout == 0L) {
                    return 600000L;
                }
                return timeout;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 600000L;
    }

    private static <T> Collection<T> unwrapFutures(Collection<Future<T>> futures) throws InterruptedException, ExecutionException {
        ArrayList<T> list = new ArrayList<T>();
        for (Future<T> result : futures) {
            T value = result.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private static class DetailedInvocation
    extends Invocation {
        private long duration;

        public DetailedInvocation(TestMethodExecutor executor, Object[] params) {
            super(executor, params);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Throwable call() throws Exception {
            this.duration = System.nanoTime();
            try {
                Throwable throwable = super.call();
                return throwable;
            }
            finally {
                this.duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.duration);
            }
        }

        public long getDuration() {
            return this.duration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimedInvocation
    extends Invocation {
        private final TestMethodExecutor executor;
        private final Object[] parameters;
        private final long end;
        private final boolean detailed;
        private final Collection<Throwable> results = new ArrayList<Throwable>();
        private final Collection<Long> durations = new ArrayList<Long>();

        public TimedInvocation(TestMethodExecutor executor, Object[] params, long end, boolean detailed) {
            super(executor, params);
            this.executor = executor;
            this.parameters = params;
            this.end = end;
            this.detailed = detailed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() throws Exception {
            long start = 0L;
            while (System.nanoTime() - this.end < 0L) {
                if (this.detailed) {
                    start = System.nanoTime();
                }
                try {
                    Throwable exception = super.call();
                    if (exception == null) continue;
                    this.results.add(exception);
                }
                finally {
                    if (!this.detailed) continue;
                    this.durations.add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
            }
            if (!this.results.isEmpty()) {
                return new MultipleExceptions(this.results);
            }
            return null;
        }

        private Collection<Long> getDurations() {
            return this.durations;
        }

        private Collection<Throwable> getResults() {
            return this.results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Invocation
    implements Callable<Throwable> {
        private final TestMethodExecutor executor;
        private final Object[] parameters;

        public Invocation(TestMethodExecutor executor, Object[] params) {
            this.executor = executor;
            this.parameters = params;
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.executor.invoke(this.parameters);
                return null;
            }
            catch (Throwable throwable) {
                return throwable;
            }
        }
    }
}

