/*
 * Decompiled with CFR 0.152.
 */
package com.github.rmannibucau.arquillian.microbenchmark.internal.shared;

import com.github.rmannibucau.arquillian.microbenchmark.api.MicroBenchmark;
import com.github.rmannibucau.arquillian.microbenchmark.internal.shared.Annotations;
import java.lang.reflect.Method;

public class MicroBenchmarkRunConfiguration {
    private int threads;
    private int iterations;
    private int duration;
    private int warmupThreads;
    private int warmupDuration;
    private int warmupIterations;
    private boolean detailed;
    private boolean ignoreExceptions;

    public static MicroBenchmarkRunConfiguration readConfiguration(Method method, boolean globallyDetailed) {
        MicroBenchmark runConfiguration = Annotations.findAnnotation(method, MicroBenchmark.class);
        if (runConfiguration == null) {
            return null;
        }
        MicroBenchmarkRunConfiguration run = new MicroBenchmarkRunConfiguration();
        run.threads = Math.max(runConfiguration.threads(), 1);
        run.detailed = runConfiguration.mode() == MicroBenchmark.Mode.DETAILED || runConfiguration.mode() == MicroBenchmark.Mode.UNKNWON && globallyDetailed;
        run.duration = runConfiguration.duration();
        run.iterations = runConfiguration.iterations();
        run.warmupThreads = Math.max(runConfiguration.warmupThreads(), 1);
        run.warmupDuration = runConfiguration.warmupDuration();
        run.warmupIterations = runConfiguration.warmupIterations();
        run.ignoreExceptions = runConfiguration.ignoreExceptions();
        return run;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getWarmupDuration() {
        return this.warmupDuration;
    }

    public int getWarmupIterations() {
        return this.warmupIterations;
    }

    public int getWarmupThreads() {
        return this.warmupThreads;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public void detailed() {
        this.detailed = true;
    }
}

