/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.maven.plugins.i18n;

import com.github.robtimus.maven.plugins.i18n.I18N;
import com.github.robtimus.maven.plugins.i18n.License;
import com.github.robtimus.maven.plugins.i18n.MapReader;
import com.github.robtimus.maven.plugins.i18n.Messages;
import com.github.robtimus.maven.plugins.i18n.Scope;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false, threadSafe=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(property="i18n.bundleName", required=true)
    String bundleName;
    @Parameter(property="i18n.sourceDirectory", defaultValue="${project.build.resources[0].directory}", required=true)
    File sourceDirectory;
    @Parameter(property="i18n.className")
    String className;
    @Parameter(property="i18n.outputDirectory", defaultValue="${project.build.directory}/generated-sources/resource-bundles", required=true)
    File outputDirectory;
    @Parameter(property="i18n.scope", defaultValue="compile")
    Scope scope;
    @Parameter(property="i18n.inputEncoding", defaultValue="${project.build.sourceEncoding}")
    String inputEncoding;
    @Parameter(property="i18n.outputEncoding", defaultValue="${project.build.sourceEncoding}")
    String outputEncoding;
    @Parameter(property="i18n.license.text")
    String licenseText;
    @Parameter(property="i18n.license.copyrightYear")
    private String licenseCopyrightYear;
    @Parameter(property="i18n.license.copyrightHolder", defaultValue="${user.name}")
    private String licenseCopyrightHolder;
    @Parameter(property="i18n.publicVisibility", defaultValue="true")
    private boolean publicVisibility;
    @Parameter(property="i18n.suppressWarnings")
    private Set<String> suppressWarnings = Collections.emptySet();
    @Parameter(property="i18n.useMessageFormat", defaultValue="false")
    private boolean useMessageFormat;

    public void execute() throws MojoExecutionException {
        I18N.Node i18n = this.readI18N();
        Charset outputCharset = this.getOutputCharset();
        License license = new License(this.getLicenseText(), this.licenseCopyrightYear, this.licenseCopyrightHolder);
        I18N.Writer writer = new I18N.Writer(outputCharset, this.publicVisibility, license, this.useMessageFormat, this.suppressWarnings);
        String i18nClassName = this.getI18NClassName();
        try {
            this.getLog().info((CharSequence)Messages.generatingClass(i18nClassName, this.bundleName));
            writer.write(i18n, this.bundleName, i18nClassName, this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.appendSourcePath();
    }

    private I18N.Node readI18N() throws MojoExecutionException {
        Map<String, String> properties = this.readProperties();
        return new I18N.Parser().parse(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map<String, String> readProperties() throws MojoExecutionException {
        Charset charset = this.getInputCharset();
        File sourceFile = this.getSourceFile();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(sourceFile), charset);){
            Map<String, String> map = MapReader.readMap(input);
            return map;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private File getSourceFile() {
        return new File(this.sourceDirectory, this.bundleName.replace('.', '/') + ".properties");
    }

    Charset getInputCharset() {
        if (this.inputEncoding == null) {
            Charset defaultCharset = Charset.defaultCharset();
            this.getLog().warn((CharSequence)Messages.noInputEncoding(defaultCharset));
            return defaultCharset;
        }
        return Charset.forName(this.inputEncoding);
    }

    Charset getOutputCharset() {
        if (this.outputEncoding == null) {
            Charset defaultCharset = Charset.defaultCharset();
            this.getLog().warn((CharSequence)Messages.noOutputEncoding(defaultCharset));
            return defaultCharset;
        }
        return Charset.forName(this.outputEncoding);
    }

    String getLicenseText() throws MojoExecutionException {
        if (this.licenseText == null) {
            return null;
        }
        try {
            URL resourceURL = GenerateMojo.class.getResource("licenses/" + this.licenseText);
            if (resourceURL != null) {
                return this.getLicenseText(resourceURL);
            }
            File licenseFile = new File(this.licenseText);
            if (licenseFile.exists()) {
                return this.getLicenseText(licenseFile);
            }
            URL licenseURL = this.createURL(this.licenseText);
            if (licenseURL != null) {
                return this.getLicenseText(licenseURL);
            }
            return this.licenseText;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String getLicenseText(URL licenseURL) throws IOException {
        try (InputStreamReader input = new InputStreamReader(licenseURL.openStream(), StandardCharsets.UTF_8);){
            String string = this.getLicenseText(input);
            return string;
        }
    }

    private String getLicenseText(File licenseFile) throws IOException {
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(licenseFile), StandardCharsets.UTF_8);){
            String string = this.getLicenseText(input);
            return string;
        }
    }

    private String getLicenseText(Reader input) throws IOException {
        int len;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[4096];
        while ((len = input.read(buffer)) != -1) {
            result.append(buffer, 0, len);
        }
        return result.toString();
    }

    String getI18NClassName() {
        if (this.className != null) {
            return this.className;
        }
        int index = this.bundleName.lastIndexOf(46);
        if (index == -1) {
            return this.capitalize(this.bundleName);
        }
        String packageName = this.bundleName.substring(0, index);
        String simpleClassName = this.capitalize(this.bundleName.substring(index + 1));
        return packageName + '.' + simpleClassName;
    }

    private String capitalize(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    void appendSourcePath() {
        List sourceRoots = this.scope == Scope.compile ? this.project.getCompileSourceRoots() : this.project.getTestCompileSourceRoots();
        String newSourcePath = this.outputDirectory.getPath();
        String newAbsoluteSourcePath = this.outputDirectory.getAbsolutePath();
        if (!sourceRoots.contains(newSourcePath) && !sourceRoots.contains(newAbsoluteSourcePath)) {
            sourceRoots.add(newAbsoluteSourcePath);
        }
    }
}

